/*
 * Decompiled with CFR 0.152.
 */
package nl.tomvanzummeren.appengine.inboundmail;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import nl.tomvanzummeren.appengine.inboundmail.Attachment;
import nl.tomvanzummeren.appengine.inboundmail.Body;

public class EmailMessage {
    private static final String PLAIN_TEXT_CONTENT_TYPE = "text/plain";
    private static final String HTML_CONTENT_TYPE = "text/html";
    private MimeMessage mimeMessage;
    private InternetAddress fromAddress;
    private InternetAddress[] toAddresses;
    private InternetAddress[] ccAddresses;
    private InternetAddress[] bccAddresses;
    private String subject;
    private List<Attachment> attachments;
    private List<Body> bodies;

    public EmailMessage(MimeMessage mimeMessage) throws MessagingException, IOException {
        this.mimeMessage = mimeMessage;
        this.bodies = new ArrayList<Body>();
        this.attachments = new ArrayList<Attachment>();
        this.parseMimeMessage();
    }

    public String getPlainTextBody() {
        return this.findBodyOfType(PLAIN_TEXT_CONTENT_TYPE);
    }

    public String getHtmlBody() {
        return this.findBodyOfType(HTML_CONTENT_TYPE);
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public InternetAddress getFromAddress() {
        return this.fromAddress;
    }

    public InternetAddress[] getToAddresses() {
        return this.toAddresses;
    }

    public InternetAddress[] getCcAddresses() {
        return this.ccAddresses;
    }

    public InternetAddress[] getBccAddresses() {
        return this.bccAddresses;
    }

    public String getSubject() {
        return this.subject;
    }

    private String findBodyOfType(String contentType) {
        for (Body body : this.bodies) {
            if (!body.getContentType().startsWith(contentType)) continue;
            return body.getContent();
        }
        return null;
    }

    private void parseMimeMessage() throws MessagingException, IOException {
        Address[] fromAddresses = this.mimeMessage.getFrom();
        if (fromAddresses.length > 0) {
            this.fromAddress = (InternetAddress)fromAddresses[0];
        }
        this.toAddresses = (InternetAddress[])this.mimeMessage.getRecipients(Message.RecipientType.TO);
        this.ccAddresses = (InternetAddress[])this.mimeMessage.getRecipients(Message.RecipientType.CC);
        this.bccAddresses = (InternetAddress[])this.mimeMessage.getRecipients(Message.RecipientType.BCC);
        this.subject = this.mimeMessage.getSubject();
        this.parseContent(this.mimeMessage.getContent(), this.mimeMessage.getContentType());
    }

    private void parseContent(Object content, String contentType) throws IOException, MessagingException {
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                this.parseContent(bodyPart.getContent(), bodyPart.getContentType());
            }
        } else if (content instanceof InputStream) {
            InputStream inputStream = (InputStream)content;
            this.attachments.add(new Attachment(contentType.toLowerCase(), inputStream));
        } else if (content instanceof String) {
            String string = (String)content;
            this.bodies.add(new Body(contentType.toLowerCase(), string));
        }
    }
}

