/*
 * Decompiled with CFR 0.152.
 */
package nl.tomvanzummeren.appengine.fileupload;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

class MultipartParameters {
    private MultiValueMap<String, MultipartFile> multipartFileParameters = new LinkedMultiValueMap();
    private Map<String, String[]> stringParameters = new HashMap<String, String[]>();

    public void addMultipartFileParameter(String name, MultipartFile file) {
        ArrayList<MultipartFile> files = (ArrayList<MultipartFile>)this.multipartFileParameters.get((Object)name);
        if (files == null) {
            files = new ArrayList<MultipartFile>();
        }
        files.add(file);
        this.multipartFileParameters.put((Object)name, files);
    }

    public void addStringParameter(String name, String value) {
        String[] existingValues = this.stringParameters.get(name);
        String[] newValues = new String[]{value};
        if (existingValues != null) {
            newValues = this.addToArray(existingValues, value);
        }
        this.stringParameters.put(name, newValues);
    }

    private String[] addToArray(String[] array, String string) {
        String[] newArray = new String[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = string;
        return newArray;
    }

    public MultiValueMap<String, MultipartFile> getMultipartFileParameters() {
        return this.multipartFileParameters;
    }

    public Map<String, String[]> getStringParameters() {
        return this.stringParameters;
    }
}

