/*
 * Decompiled with CFR 0.152.
 */
package nl.tomvanzummeren.appengine.fileupload;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.tomvanzummeren.appengine.fileupload.CommonsStreamMultipartFile;
import nl.tomvanzummeren.appengine.fileupload.MultipartParameters;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;

public class CommonsStreamMultipartResolver
implements MultipartResolver {
    public boolean isMultipart(HttpServletRequest request) {
        return request != null && ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        MultipartParameters multipartParameters;
        ServletFileUpload upload = new ServletFileUpload();
        try {
            FileItemIterator iterator = upload.getItemIterator(request);
            multipartParameters = this.parseFileItems(iterator);
        }
        catch (FileUploadException e) {
            throw new MultipartException("Could not parse multipart servlet request", (Throwable)e);
        }
        catch (IOException e) {
            throw new MultipartException("Could not parse multipart servlet request", (Throwable)e);
        }
        MultiValueMap<String, MultipartFile> fileParameters = multipartParameters.getMultipartFileParameters();
        Map<String, String[]> stringParameters = multipartParameters.getStringParameters();
        return new DefaultMultipartHttpServletRequest(request, fileParameters, stringParameters);
    }

    private MultipartParameters parseFileItems(FileItemIterator iterator) throws FileUploadException, IOException {
        MultipartParameters multipartParameters = new MultipartParameters();
        while (iterator.hasNext()) {
            FileItemStream fileItemStream = iterator.next();
            String fieldName = fileItemStream.getFieldName();
            if (fileItemStream.getContentType() == null) {
                String fieldValue = FileCopyUtils.copyToString((Reader)new InputStreamReader(fileItemStream.openStream()));
                multipartParameters.addStringParameter(fieldName, fieldValue);
                continue;
            }
            CommonsStreamMultipartFile multipartFile = new CommonsStreamMultipartFile(fileItemStream);
            multipartParameters.addMultipartFileParameter(fieldName, multipartFile);
        }
        return multipartParameters;
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
    }
}

