/*
 * Decompiled with CFR 0.152.
 */
package nl.tomvanzummeren.appengine.fileupload;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItemStream;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class CommonsStreamMultipartFile
implements MultipartFile {
    private String name;
    private String originalFilename;
    private String contentType;
    private byte[] fileContent;

    public CommonsStreamMultipartFile(FileItemStream fileItemStream) throws IOException {
        this.name = fileItemStream.getFieldName();
        this.originalFilename = fileItemStream.getName();
        this.contentType = fileItemStream.getContentType();
        this.fileContent = FileCopyUtils.copyToByteArray((InputStream)fileItemStream.openStream());
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.fileContent.length == 0;
    }

    public long getSize() {
        return this.fileContent.length;
    }

    public byte[] getBytes() throws IOException {
        return this.fileContent;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.fileContent);
    }

    public void transferTo(File destination) throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported by the Google App Engine");
    }
}

