/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.MultipartWrapper;
import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class MultipartFilter
implements Filter {
    private FilterConfig config = null;
    private String dir = null;
    private String encoding = null;
    private int maxPostSize = 0;

    public void init(FilterConfig config) throws ServletException {
        this.config = config;
        this.dir = config.getInitParameter("uploadDir");
        if (this.dir == null) {
            File tempdir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
            if (tempdir != null) {
                this.dir = tempdir.toString();
            } else {
                throw new ServletException("MultipartFilter: No upload directory found: set an uploadDir init parameter or ensure the javax.servlet.context.tempdir directory is valid");
            }
        }
        this.encoding = config.getInitParameter("encoding");
        try {
            this.maxPostSize = Integer.parseInt(config.getInitParameter("maxpostsize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void destroy() {
        this.config = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String type = req.getHeader("Content-Type");
        if (type == null || !type.startsWith("multipart/form-data")) {
            if (this.encoding != null) {
                request.setCharacterEncoding(this.encoding);
            }
            chain.doFilter(request, response);
        } else {
            MultipartWrapper multi = this.maxPostSize != 0 ? new MultipartWrapper(req, this.dir, this.maxPostSize, this.encoding) : new MultipartWrapper(req, this.dir, this.encoding);
            chain.doFilter((ServletRequest)multi, response);
        }
    }
}

