package cz.geek.banking.hibernate;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import cz.geek.banking.BankStatement;
import cz.geek.banking.TransactionAspect;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Repository
public class BankStatementDao {

	@PersistenceContext
	private EntityManager entityManager;

	public List<BankStatement> findUnpaired(TransactionAspect aspect) {
		StringBuilder query = new StringBuilder();
		query.append("from BankStatement where givenVs is null");
		if (aspect.getOperator() != null) {
			query.append(" and amount").append(aspect.getOperator()).append("0");
		}
		query.append(" order by date desc");
		return entityManager.createQuery(query.toString(), BankStatement.class).getResultList();
	}

	public Multimap<Long, BankStatement> findUnpairedMap(TransactionAspect aspect) {
		List<BankStatement> unpaired = findUnpaired(aspect);
		Multimap<Long, BankStatement> result = LinkedListMultimap.create();
		for (BankStatement i: unpaired) {
			result.put(i.getOriginalVs(), i);
		}
		return result;
	}

	public List<BankStatement> findById(Collection<Integer> ids) {
		if (ids == null || ids.isEmpty())
			return Collections.emptyList();
		return entityManager.createQuery("from BankStatement where id in (:ids)", BankStatement.class)
				.setParameter("ids", ids)
				.getResultList();
	}

	@Transactional
	public void save(BankStatement bankStatement) {
		entityManager.persist(bankStatement);
	}
}
