package cz.geek.banking;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDate;

import static javax.persistence.GenerationType.IDENTITY;

@Entity
@Table(name = "bankstatement")
public class BankStatement {

	@Id @GeneratedValue(strategy = IDENTITY)
	private Integer id;

	private LocalDate date;

	@Column(name = "originalvs")
	private Long originalVs;

	@Column(name = "givenvs")
	private Long givenVs;

	private String ss;

	private String ks;

	private BigDecimal amount;

	private String note;

	public BankStatement() {
	}

	public BankStatement(LocalDate date, Long originalVs, String ss, String ks, BigDecimal amount, String note) {
		this.date = date;
		this.originalVs = originalVs;
		this.ss = ss;
		this.ks = ks;
		this.amount = amount;
		this.note = note;
	}

	public Integer getId() {
		return id;
	}

	public LocalDate getDate() {
		return date;
	}

	public void setDate(LocalDate date) {
		this.date = date;
	}

	public Long getOriginalVs() {
		return originalVs;
	}

	public void setOriginalVs(Long originalVs) {
		this.originalVs = originalVs;
	}

	public void setGivenVs(Long givenVs) {
		this.givenVs = givenVs;
	}

	public String getSs() {
		return ss;
	}

	public void setSs(String ss) {
		this.ss = ss;
	}

	public String getKs() {
		return ks;
	}

	public void setKs(String ks) {
		this.ks = ks;
	}

	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder();
		sb.append("BankStatement");
		sb.append("{id=").append(id);
		sb.append(", date=").append(date);
		sb.append(", originalVs='").append(originalVs).append('\'');
		sb.append(", givenVs='").append(givenVs).append('\'');
		sb.append(", ss='").append(ss).append('\'');
		sb.append(", ks='").append(ks).append('\'');
		sb.append(", amount=").append(amount);
		sb.append(", note='").append(note).append('\'');
		sb.append('}');
		return sb.toString();
	}
}
