/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.banking.fio;

import cz.geek.banking.BankStatement;
import cz.geek.banking.BankStatementImporterException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class FioImporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Session session = Session.getDefaultInstance((Properties)new Properties());
    private final DecimalFormat fmt = (DecimalFormat)NumberFormat.getInstance(new Locale("cs"));

    public FioImporter() {
        this.fmt.setParseBigDecimal(true);
    }

    public BankStatement parse(InputStream is) {
        this.log.info("Processing message");
        Assert.notNull((Object)is, (String)"Input stream must not be null");
        try {
            MimeMessage msg = new MimeMessage(this.session, is);
            BankStatement bankStatement = this.parse((Part)msg);
            return bankStatement;
        }
        catch (MessagingException e) {
            throw new BankStatementImporterException("Unable to parse message", e);
        }
        catch (IOException e) {
            throw new BankStatementImporterException("Unable to read message content", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    private BankStatement parse(Part part) throws IOException, MessagingException {
        if (part.getContent() instanceof String) {
            String content = (String)part.getContent();
            return this.doParse(content);
        }
        if (part.getContent() instanceof MimeMultipart) {
            MimeMultipart content = (MimeMultipart)part.getContent();
            if (content.getCount() == 1) {
                BodyPart bodyPart = content.getBodyPart(0);
                return this.parse((Part)bodyPart);
            }
            throw new BankStatementImporterException("Invalid number of parts: " + content.getCount());
        }
        throw new BankStatementImporterException("Unknown part " + part.getContent().getClass());
    }

    public BankStatement parse(String email) {
        Assert.notNull((Object)email, (String)"Input must not be null");
        return this.parse(new ByteArrayInputStream(email.getBytes(Charset.forName("UTF-8"))));
    }

    protected BankStatement doParse(String content) {
        String note;
        this.log.debug("Message content:\n {}", (Object)content);
        boolean negate = false;
        Map<String, String> values = this.parseContent(content);
        String value = StringUtils.deleteWhitespace((String)values.get("\u010c\u00e1stka"));
        if (values.get("V\u00fddaj na kont\u011b") != null) {
            note = values.get("US");
            negate = true;
        } else {
            note = values.get("Zpr\u00e1va p\u0159\u00edjemci");
        }
        note = StringUtils.strip((String)note);
        try {
            String vs;
            BigDecimal amount = (BigDecimal)this.fmt.parse(value);
            if (negate) {
                amount = amount.negate();
            }
            Long v = StringUtils.isNotBlank((String)(vs = values.get("VS"))) ? Long.valueOf(StringUtils.strip((String)vs)) : null;
            BankStatement bs = new BankStatement(new Date(), v, values.get("SS"), values.get("KS"), amount, note);
            this.log.debug("Parsed {}", (Object)bs);
            return bs;
        }
        catch (ParseException e) {
            throw new BankStatementImporterException("Unable to parse '" + value + "' at position " + e.getErrorOffset(), e);
        }
    }

    private Map<String, String> parseContent(String content) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        StringTokenizer st = new StringTokenizer(content, "\n");
        int lines = 0;
        while (st.hasMoreTokens()) {
            ++lines;
            String line = st.nextToken();
            String[] split = line.split(": ", 2);
            if (split.length != 2) {
                this.log.warn("Skipping line {}: {}", (Object)lines, (Object)line);
                continue;
            }
            values.put(split[0], split[1]);
        }
        return values;
    }
}

