/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;

public class POP3Downloader {
    public static final String PROTOCOL = "pop3";
    private final String host;
    private final String user;
    private final String pass;
    private final Store store;

    public POP3Downloader(String host, String user, String pass) {
        this.host = host;
        this.user = user;
        this.pass = pass;
        try {
            this.store = Session.getDefaultInstance((Properties)new Properties()).getStore(PROTOCOL);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Unknown protocol: pop3", e);
        }
    }

    public void process() throws Exception {
        this.store.connect(this.host, this.user, this.pass);
        Folder folder = this.store.getFolder("INBOX");
        folder.open(2);
        for (Message m : folder.getMessages()) {
            m.setFlag(Flags.Flag.DELETED, true);
        }
        folder.close(true);
        this.store.close();
    }
}

