package cz.geek.banking.hibernate;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import cz.geek.banking.BankStatement;
import cz.geek.banking.TransactionAspect;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Repository
@SuppressWarnings("unchecked")
public class BankStatementDao {

	@Autowired
	private SessionFactory sessionFactory;

	protected Session session() {
		return sessionFactory.getCurrentSession();
	}

	public List<BankStatement> findUnpaired(TransactionAspect aspect) {
		Criteria c = session().createCriteria(BankStatement.class)
				.add(Restrictions.isNull("givenVs")).addOrder(Order.desc("date"));
		switch (aspect) {
			case CREDIT: c.add(Restrictions.gt("amount", 0)); break;
			case DEBIT:  c.add(Restrictions.lt("amount", 0)); break;
		}
		return c.list();
	}

	public Multimap<Long, BankStatement> findUnpairedMap(TransactionAspect aspect) {
		List<BankStatement> unpaired = findUnpaired(aspect);
		Multimap<Long, BankStatement> result = LinkedListMultimap.create();
		for (BankStatement i: unpaired) {
			result.put(i.getOriginalVs(), i);
		}
		return result;
	}

	public List<BankStatement> findById(Collection<Integer> ids) {
		if (ids == null || ids.isEmpty())
			return Collections.emptyList();
		return session().createQuery("from BankStatement where id in (:ids)").setParameterList("ids", ids).list();
	}

	@Transactional
	public void save(BankStatement bankStatement) {
		session().save(bankStatement);
	}
}
