/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.banking;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class Pairs {
    private Integer[] ids;
    private Long[] givenVs;
    private Map<Integer, Long> map;

    public void setIds(Integer[] ids) {
        this.ids = ids;
    }

    public void setGivenVs(Long[] givenVs) {
        this.givenVs = givenVs;
    }

    public Set<Integer> getPairedIds() {
        Validate.notNull((Object)this.ids, (String)"ids can not be null");
        Validate.notNull((Object)this.givenVs, (String)"givenVs can not be null");
        Validate.isTrue((this.ids.length == this.givenVs.length ? 1 : 0) != 0, (String)"ids and givenVs must have same length");
        this.map = new LinkedHashMap<Integer, Long>(this.ids.length);
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.givenVs[i] == null) continue;
            this.map.put(this.ids[i], this.givenVs[i]);
        }
        return this.map.keySet();
    }

    public Set<Long> getPairedVs() {
        Validate.notNull(this.map, (String)"First call getPairedIds()");
        return new LinkedHashSet<Long>(this.map.values());
    }

    public Long vsForId(Integer id) {
        return this.map.get(id);
    }
}

