/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.banking.hibernate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cz.geek.banking.BankStatement;
import cz.geek.banking.TransactionAspect;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BankStatementDao {
    @Autowired
    private SessionFactory sessionFactory;

    protected Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    public List<BankStatement> findUnpaired(TransactionAspect aspect) {
        Criteria c = this.session().createCriteria(BankStatement.class).add(Restrictions.isNull((String)"givenVs")).addOrder(Order.desc((String)"date"));
        switch (aspect) {
            case CREDIT: {
                c.add((Criterion)Restrictions.gt((String)"amount", (Object)0));
                break;
            }
            case DEBIT: {
                c.add((Criterion)Restrictions.lt((String)"amount", (Object)0));
            }
        }
        return c.list();
    }

    public Multimap<Long, BankStatement> findUnpairedMap(TransactionAspect aspect) {
        List<BankStatement> unpaired = this.findUnpaired(aspect);
        ArrayListMultimap result = ArrayListMultimap.create();
        for (BankStatement i : unpaired) {
            result.put((Object)i.getOriginalVs(), (Object)i);
        }
        return result;
    }

    public List<BankStatement> findById(Collection<Integer> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.session().createQuery("from BankStatement where id in (:ids)").setParameterList("ids", ids).list();
    }

    @Transactional
    public void save(BankStatement bankStatement) {
        this.session().save((Object)bankStatement);
    }
}

