package cz.geek.banking;

import org.apache.commons.lang.Validate;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Pairs {
	private Integer[] ids;
	private Long[] givenVs;
	private Map<Integer,Long> map;

	public void setIds(Integer[] ids) {
		this.ids = ids;
	}

	public void setGivenVs(Long[] givenVs) {
		this.givenVs = givenVs;
	}

	public Set<Integer> getPairedIds() {
		Validate.notNull(ids, "ids can not be null");
		Validate.notNull(givenVs, "givenVs can not be null");
		Validate.isTrue(ids.length == givenVs.length, "ids and givenVs must have same length");
		map = new LinkedHashMap<Integer, Long>(ids.length);
		for (int i=0; i<ids.length; i++) {
			if (givenVs[i] != null)
				map.put(ids[i], givenVs[i]);
		}
		return map.keySet();
	}

	public Set<Long> getPairedVs() {
		Validate.notNull(map, "First call getPairedIds()");
		return new LinkedHashSet<Long>(map.values());
	}

	public Long vsForId(Integer id) {
		return map.get(id);
	}
}
