package cz.geek.banking.hibernate;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cz.geek.banking.BankStatement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.*;

@Repository
@SuppressWarnings("unchecked")
public class BankStatementDao {

	@Autowired
	private SessionFactory sessionFactory;

	protected Session session() {
		return sessionFactory.getCurrentSession();
	}

	public List<BankStatement> findUnpaired() {
		return session().createQuery("from BankStatement where givenVs is null and amount > 0 order by date desc").list();
	}

	public Multimap<Long, BankStatement> findUnpairedMap() {
		List<BankStatement> unpaired = findUnpaired();
		Multimap<Long, BankStatement> result = ArrayListMultimap.create();
		for (BankStatement i: unpaired) {
			result.put(i.getOriginalVs(), i);
		}
		return result;
	}

	public List<BankStatement> findById(Collection<Integer> ids) {
		if (ids == null || ids.isEmpty())
			return Collections.emptyList();
		return session().createQuery("from BankStatement where id in (:ids)").setParameterList("ids", ids).list();
	}

	@Transactional
	public void save(BankStatement bankStatement) {
		session().save(bankStatement);
	}
}
