import javax.mail.*;
import java.util.Properties;

public class POP3Downloader {

	public static final String PROTOCOL = "pop3";
	private final String host;
	private final String user;
	private final String pass;
	private final Store store;

	public POP3Downloader(String host, String user, String pass) {
		this.host = host;
		this.user = user;
		this.pass = pass;
		try {
			store = Session.getDefaultInstance(new Properties()).getStore(PROTOCOL);
		} catch (NoSuchProviderException e) {
			throw new RuntimeException("Unknown protocol: " + PROTOCOL, e);
		}
	}

	public void process() throws Exception {
		store.connect(host, user, pass);
		Folder folder = store.getFolder("INBOX");
		folder.open(Folder.READ_WRITE);
		for (Message m: folder.getMessages()) {
			m.setFlag(Flags.Flag.DELETED, true);
		}
		folder.close(true);
		store.close();
	}
}
