package cz.geek.banking.hibernate;

import cz.geek.banking.BankStatement;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Repository
@SuppressWarnings("unchecked")
public class BankStatementDao {

	@Autowired
	private SessionFactory sessionFactory;

	protected Session session() {
		return sessionFactory.getCurrentSession();
	}

	public List<BankStatement> findUnpaired() {
		return session().createQuery("from BankStatement where givenVs is null and amount > 0 order by date desc").list();
	}

	public Map<Long, BankStatement> findUnpairedMap() {
		List<BankStatement> unpaired = findUnpaired();
		Map<Long, BankStatement> result = new LinkedHashMap<Long, BankStatement>(unpaired.size());
		for (BankStatement i: unpaired) {
			result.put(i.getOriginalVs(), i);
		}
		return result;
	}

	private List<Long> findUnpairedMap(List<BankStatement> unpaired) {
		List<Long> result = new ArrayList<Long>(unpaired.size());
		for (BankStatement i: unpaired) {
			result.add(i.getOriginalVs());
		}
		return result;
	}


	public List<BankStatement> findById(Collection<Integer> ids) {
		if (ids == null || ids.isEmpty())
			return Collections.emptyList();
		return session().createQuery("from BankStatement where id in (:ids)").setParameterList("ids", ids).list();
	}

	@Transactional
	public void save(BankStatement bankStatement) {
		session().save(bankStatement);
	}
}
