/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.gdata.client;

import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.util.AuthenticationException;
import cz.geek.cache.Cache;
import cz.geek.gdata.client.CachedResponse;
import cz.geek.gdata.client.CachingRequestFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceFactory {
    public static <T extends GoogleService> T getService(T service, String username, String password) throws AuthenticationException {
        service.setUserCredentials(username, password);
        return service;
    }

    public static <T extends GoogleService> T getService(T service, String authSubToken) throws AuthenticationException {
        service.setAuthSubToken(authSubToken);
        return service;
    }

    public static <T extends Service> T getService(T service, Cache<String, CachedResponse> cache) {
        service.setRequestFactory((Service.GDataRequestFactory)new CachingRequestFactory(cache));
        return service;
    }

    public static <T extends GoogleService> T getService(T service, Cache<String, CachedResponse> cache, String username, String password) throws AuthenticationException {
        T cached = ServiceFactory.getService(service, cache);
        T auth = ServiceFactory.getService(cached, username, password);
        return auth;
    }

    public static <T extends GoogleService> T getService(T service, Cache<String, CachedResponse> cache, String authSubToken) throws AuthenticationException {
        T cached = ServiceFactory.getService(service, cache);
        T auth = ServiceFactory.getService(cached, authSubToken);
        return auth;
    }
}

