package cz.geek.gdata.docs;

import com.google.gdata.client.docs.DocsService;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.media.MediaSource;

import java.io.InputStream;
import java.net.URL;

public class Docs {
	private static final String BASE_URL = "https://docs.google.com/feeds/";
	private static final String EXPORT_URL = BASE_URL + "download/documents/Export?exportFormat=%s&id=%s";
	private static final String URL = BASE_URL + "documents/private/full/";

	protected DocsService service;

	public Docs(DocsService service) {
		super();
		this.service = service;
	}

	public InputStream export(String docid, ExportFormat format) throws Exception {
		URL exportUrl = new URL(String.format(EXPORT_URL, format.name(), docid));
		MediaContent mc = new MediaContent();
		mc.setUri(exportUrl.toString());
		MediaSource ms = service.getMedia(mc);
		InputStream is = ms.getInputStream();
		return is;
	}

}
