package cz.geek.picasa;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.xml.sax.Attributes;

import com.google.gdata.client.Service;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Category;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.Generator;
import com.google.gdata.data.Link;
import com.google.gdata.data.Person;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.XmlEventSource;
import com.google.gdata.data.ExtensionVisitor.StoppedException;
import com.google.gdata.data.Kind.Adaptor;
import com.google.gdata.data.Kind.AdaptorException;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.photos.AlbumEntry;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.TagEntry;
import com.google.gdata.data.photos.UserFeed;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser.ElementHandler;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;

public class UserBean {
	
	private UserFeed userFeed;
	private List<AlbumEntryBean> albumEntries;

	public UserBean(UserFeed userFeed) {
		this.userFeed = userFeed;
		setAlbumEntryBeans();
	}
	
	private void setAlbumEntryBeans() {
		albumEntries = new ArrayList<AlbumEntryBean>(userFeed.getAlbumEntries().size());
		for (AlbumEntry i: userFeed.getAlbumEntries())
			albumEntries.add(new AlbumEntryBean(i));
	}

	public List<AlbumEntryBean> getAlbumEntryBeans() {
		return albumEntries;
	}

	public List<AlbumEntry> getAlbumEntries() {
		return userFeed.getAlbumEntries();
	}

	public void addAdaptor(Adaptor adaptor) {
		userFeed.addAdaptor(adaptor);
	}

	public void addExtension(Extension ext) {
		userFeed.addExtension(ext);
	}

	public void addHtmlLink(String htmlUri, String lang, String title) {
		userFeed.addHtmlLink(htmlUri, lang, title);
	}

	public void addLink(Link link) {
		userFeed.addLink(link);
	}

	public Link addLink(String rel, String type, String href) {
		return userFeed.addLink(rel, type, href);
	}

	public void addRepeatingExtension(Extension ext) {
		userFeed.addRepeatingExtension(ext);
	}

	public GphotoEntry createEntry() {
		return userFeed.createEntry();
	}

	public void declareExtensions(ExtensionProfile extProfile) {
		userFeed.declareExtensions(extProfile);
	}

	@Override
	public boolean equals(Object obj) {
		return userFeed.equals(obj);
	}

	public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
		userFeed.generate(w, p);
	}

	public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
		userFeed.generateAtom(w, extProfile);
	}

	public XmlBlob generateCumulativeXmlBlob(ExtensionProfile arg0) throws IOException {
		return userFeed.generateCumulativeXmlBlob(arg0);
	}

	public void generateFeedEnd(XmlWriter w) throws IOException {
		userFeed.generateFeedEnd(w);
	}

	public void generateFeedStart(ExtensionProfile extProfile, XmlWriter w, Collection<XmlNamespace> namespaces) throws IOException {
		userFeed.generateFeedStart(extProfile, w, namespaces);
	}

	public void generateRss(XmlWriter w, ExtensionProfile extProfile) throws IOException {
		userFeed.generateRss(w, extProfile);
	}

	public BaseFeed<?, ?> getAdaptedFeed() throws AdaptorException {
		return userFeed.getAdaptedFeed();
	}

	public <A extends Adaptor> A getAdaptor(Class<A> adaptorClass) {
		return userFeed.getAdaptor(adaptorClass);
	}

	public Collection<Adaptor> getAdaptors() {
		return userFeed.getAdaptors();
	}

	public List<Person> getAuthors() {
		return userFeed.getAuthors();
	}

	public boolean getCanPost() {
		return userFeed.getCanPost();
	}

	public Set<Category> getCategories() {
		return userFeed.getCategories();
	}

	public List<Person> getContributors() {
		return userFeed.getContributors();
	}

	public TextConstruct getDescription() {
		return userFeed.getDescription();
	}

	public List<GphotoEntry> getEntries() {
		return userFeed.getEntries();
	}

	public <T extends BaseEntry> List<T> getEntries(Class<T> arg0) {
		return userFeed.getEntries(arg0);
	}

	public Link getEntryPostLink() {
		return userFeed.getEntryPostLink();
	}

	public String getEtag() {
		return userFeed.getEtag();
	}

	public <T extends Extension> T getExtension(Class<T> extensionClass) {
		return userFeed.getExtension(extensionClass);
	}

	public final String getExtensionLocalName() {
		return userFeed.getExtensionLocalName();
	}

	public final XmlNamespace getExtensionNamespace() {
		return userFeed.getExtensionNamespace();
	}

	public Collection<Extension> getExtensions() {
		return userFeed.getExtensions();
	}

	public Link getFeedBatchLink() {
		return userFeed.getFeedBatchLink();
	}

	public Generator getGenerator() {
		return userFeed.getGenerator();
	}

	public String getGphotoId() {
		return userFeed.getGphotoId();
	}

	public ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) throws ParseException {
		return userFeed.getHandler(p, namespace, localName, attrs);
	}

	public Link getHtmlLink() {
		return userFeed.getHtmlLink();
	}

	public String getIcon() {
		return userFeed.getIcon();
	}

	public String getId() {
		return userFeed.getId();
	}

	public int getItemsPerPage() {
		return userFeed.getItemsPerPage();
	}

	public Link getLink(String arg0, String arg1) {
		return userFeed.getLink(arg0, arg1);
	}

	public List<Link> getLinks() {
		return userFeed.getLinks();
	}

	public List<Link> getLinks(String arg0, String arg1) {
		return userFeed.getLinks(arg0, arg1);
	}

	public String getLogo() {
		return userFeed.getLogo();
	}

	public Integer getMaxPhotos() {
		return userFeed.getMaxPhotos();
	}

	public Link getNextLink() {
		return userFeed.getNextLink();
	}

	public String getNickname() {
		return userFeed.getNickname();
	}

	public Link getPreviousLink() {
		return userFeed.getPreviousLink();
	}

	public Long getQuotaLimit() {
		return userFeed.getQuotaLimit();
	}

	public Long getQuotaUsed() {
		return userFeed.getQuotaUsed();
	}

	public <T extends Extension> List<T> getRepeatingExtension(Class<T> extensionClass) {
		return userFeed.getRepeatingExtension(extensionClass);
	}

	public Collection<List<Extension>> getRepeatingExtensions() {
		return userFeed.getRepeatingExtensions();
	}

	public TextConstruct getRights() {
		return userFeed.getRights();
	}

	public UserFeed getSelf() throws IOException, ServiceException {
		return userFeed.getSelf();
	}

	public Link getSelfLink() {
		return userFeed.getSelfLink();
	}

	public Service getService() {
		return userFeed.getService();
	}

	public int getStartIndex() {
		return userFeed.getStartIndex();
	}

	public TextConstruct getSubtitle() {
		return userFeed.getSubtitle();
	}

	public List<TagEntry> getTagEntries() {
		return userFeed.getTagEntries();
	}

	public String getThumbnail() {
		return userFeed.getThumbnail();
	}

	public TextConstruct getTitle() {
		return userFeed.getTitle();
	}

	public int getTotalResults() {
		return userFeed.getTotalResults();
	}

	public DateTime getUpdated() {
		return userFeed.getUpdated();
	}

	public String getUsername() {
		return userFeed.getUsername();
	}

	public XmlBlob getXmlBlob() {
		return userFeed.getXmlBlob();
	}

	public final <T extends Extension> boolean hasExtension(Class<T> extensionClass) {
		return userFeed.hasExtension(extensionClass);
	}

	@Override
	public int hashCode() {
		return userFeed.hashCode();
	}

	public final <T extends Extension> boolean hasRepeatingExtension(Class<T> extensionClass) {
		return userFeed.hasRepeatingExtension(extensionClass);
	}

	public GphotoEntry insert(MediaSource media) throws ServiceException, IOException {
		return userFeed.insert(media);
	}

	public <T extends GphotoEntry> T insert(T newEntry) throws ServiceException, IOException {
		return userFeed.insert(newEntry);
	}

	public final boolean isImmutable() {
		return userFeed.isImmutable();
	}

	public void parseAtom(ExtensionProfile extProfile, InputStream input) throws IOException, ParseException {
		userFeed.parseAtom(extProfile, input);
	}

	public void parseAtom(ExtensionProfile extProfile, Reader reader) throws IOException, ParseException {
		userFeed.parseAtom(extProfile, reader);
	}

	public void parseAtom(ExtensionProfile extProfile, XmlEventSource source) throws IOException, ParseException {
		userFeed.parseAtom(extProfile, source);
	}

	public void parseCumulativeXmlBlob(XmlBlob blob, ExtensionProfile extProfile, Class<? extends ExtensionPoint> extendedClass) throws IOException,
			ParseException {
		userFeed.parseCumulativeXmlBlob(blob, extProfile, extendedClass);
	}

	public void removeExtension(Class<? extends Extension> extensionClass) {
		userFeed.removeExtension(extensionClass);
	}

	public void removeExtension(Extension ext) {
		userFeed.removeExtension(ext);
	}

	public void removeLinks(String arg0, String arg1) {
		userFeed.removeLinks(arg0, arg1);
	}

	public void removeRepeatingExtension(Extension ext) {
		userFeed.removeRepeatingExtension(ext);
	}

	public void setCanPost(boolean v) {
		userFeed.setCanPost(v);
	}

	public void setDescription(TextConstruct description) {
		userFeed.setDescription(description);
	}

	public void setEntries(List<GphotoEntry> entryList) {
		userFeed.setEntries(entryList);
	}

	public void setEtag(String v) {
		userFeed.setEtag(v);
	}

	public void setExtension(Extension ext) {
		userFeed.setExtension(ext);
	}

	public void setGenerator(Generator v) {
		userFeed.setGenerator(v);
	}

	public Generator setGenerator(String version, String uri, String name) {
		return userFeed.setGenerator(version, uri, name);
	}

	public void setGphotoId(Long id) {
		userFeed.setGphotoId(id);
	}

	public void setGphotoId(String id) {
		userFeed.setGphotoId(id);
	}

	public void setIcon(String v) {
		userFeed.setIcon(v);
	}

	public void setId(String v) {
		userFeed.setId(v);
	}

	public final void setImmutable(boolean isImmutable) {
		userFeed.setImmutable(isImmutable);
	}

	public void setItemsPerPage(int v) {
		userFeed.setItemsPerPage(v);
	}

	public void setLogo(String v) {
		userFeed.setLogo(v);
	}

	public void setMaxPhotos(Integer max) {
		userFeed.setMaxPhotos(max);
	}

	public void setNickname(String nickname) {
		userFeed.setNickname(nickname);
	}

	public void setQuotaLimit(Long quota) {
		userFeed.setQuotaLimit(quota);
	}

	public void setQuotaUsed(Long quota) {
		userFeed.setQuotaUsed(quota);
	}

	public void setRights(TextConstruct v) {
		userFeed.setRights(v);
	}

	public void setService(Service v) {
		userFeed.setService(v);
	}

	public void setStartIndex(int v) {
		userFeed.setStartIndex(v);
	}

	public void setSubtitle(TextConstruct v) {
		userFeed.setSubtitle(v);
	}

	public void setThumbnail(String thumbnail) {
		userFeed.setThumbnail(thumbnail);
	}

	public void setTitle(TextConstruct v) {
		userFeed.setTitle(v);
	}

	public void setTotalResults(int v) {
		userFeed.setTotalResults(v);
	}

	public void setUpdated(DateTime v) {
		userFeed.setUpdated(v);
	}

	public void setUsername(String username) {
		userFeed.setUsername(username);
	}

	public void setXmlBlob(XmlBlob xmlBlob) {
		userFeed.setXmlBlob(xmlBlob);
	}

	@Override
	public String toString() {
		return userFeed.toString();
	}

	public void visit(ExtensionVisitor ev, ExtensionPoint parent) throws StoppedException {
		userFeed.visit(ev, parent);
	}

}
