package cz.geek.picasa;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

import org.xml.sax.Attributes;

import com.google.gdata.client.Service;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Category;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.ExtensionVisitor.StoppedException;
import com.google.gdata.data.Generator;
import com.google.gdata.data.Kind.Adaptor;
import com.google.gdata.data.Kind.AdaptorException;
import com.google.gdata.data.Link;
import com.google.gdata.data.Person;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.XmlEventSource;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaCredit;
import com.google.gdata.data.media.mediarss.MediaGroup;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.photos.AlbumFeed;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.PhotoEntry;
import com.google.gdata.data.photos.TagEntry;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser.ElementHandler;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;

public class AlbumBean {
	
	private AlbumFeed album;
	private List<PhotoBean> entries;
	private Icon icon;

	public AlbumBean(AlbumFeed album) {
		super();
		this.album = album;
		setEntries();
		this.icon = new Icon(album.getIcon());
	}
	
	private void setEntries() {
		List<PhotoEntry> list = album.getPhotoEntries();
		entries = new ArrayList<PhotoBean>(list.size());
		for (PhotoEntry i : list) {
			entries.add(new PhotoBean(i));
		}
	}
	
	public List<PhotoBean> getPhotoEntries() {
		return entries;
	}
	
	public Icon getIconMedia() {
		return icon;
	}

	public void addAdaptor(Adaptor adaptor) {
		album.addAdaptor(adaptor);
	}

	public void addExtension(Extension ext) {
		album.addExtension(ext);
	}

	public void addHtmlLink(String htmlUri, String lang, String title) {
		album.addHtmlLink(htmlUri, lang, title);
	}

	public void addLink(Link link) {
		album.addLink(link);
	}

	public Link addLink(String rel, String type, String href) {
		return album.addLink(rel, type, href);
	}

	public void addRepeatingExtension(Extension ext) {
		album.addRepeatingExtension(ext);
	}

	public void clearGeoBoundingBox() {
		album.clearGeoBoundingBox();
	}

	public void clearPoint() {
		album.clearPoint();
	}

	public GphotoEntry createEntry() {
		return album.createEntry();
	}

	public void declareExtensions(ExtensionProfile extProfile) {
		album.declareExtensions(extProfile);
	}

	@Override
	public boolean equals(Object obj) {
		return album.equals(obj);
	}

	public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
		album.generate(w, p);
	}

	public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
		album.generateAtom(w, extProfile);
	}

	public XmlBlob generateCumulativeXmlBlob(ExtensionProfile arg0) throws IOException {
		return album.generateCumulativeXmlBlob(arg0);
	}

	public void generateFeedEnd(XmlWriter w) throws IOException {
		album.generateFeedEnd(w);
	}

	public void generateFeedStart(ExtensionProfile extProfile, XmlWriter w, Collection<XmlNamespace> namespaces) throws IOException {
		album.generateFeedStart(extProfile, w, namespaces);
	}

	public void generateRss(XmlWriter w, ExtensionProfile extProfile) throws IOException {
		album.generateRss(w, extProfile);
	}

	public String getAccess() {
		return album.getAccess();
	}

	public BaseFeed<?, ?> getAdaptedFeed() throws AdaptorException {
		return album.getAdaptedFeed();
	}

	public <A extends Adaptor> A getAdaptor(Class<A> adaptorClass) {
		return album.getAdaptor(adaptorClass);
	}

	public Collection<Adaptor> getAdaptors() {
		return album.getAdaptors();
	}

	public List<Person> getAuthors() {
		return album.getAuthors();
	}

	public Long getBytesUsed() throws ServiceException {
		return album.getBytesUsed();
	}

	public boolean getCanPost() {
		return album.getCanPost();
	}

	public Set<Category> getCategories() {
		return album.getCategories();
	}

	public Integer getCommentCount() throws ServiceException {
		return album.getCommentCount();
	}

	public Boolean getCommentsEnabled() throws ServiceException {
		return album.getCommentsEnabled();
	}

	public List<Person> getContributors() {
		return album.getContributors();
	}

	public Date getDate() throws ServiceException {
		return album.getDate();
	}

	public TextConstruct getDescription() {
		return album.getDescription();
	}

	public List<GphotoEntry> getEntries() {
		return album.getEntries();
	}

	public <T extends BaseEntry> List<T> getEntries(Class<T> arg0) {
		return album.getEntries(arg0);
	}

	public Link getEntryPostLink() {
		return album.getEntryPostLink();
	}

	public String getEtag() {
		return album.getEtag();
	}

	public <T extends Extension> T getExtension(Class<T> extensionClass) {
		return album.getExtension(extensionClass);
	}

	public final String getExtensionLocalName() {
		return album.getExtensionLocalName();
	}

	public final XmlNamespace getExtensionNamespace() {
		return album.getExtensionNamespace();
	}

	public Collection<Extension> getExtensions() {
		return album.getExtensions();
	}

	public Link getFeedBatchLink() {
		return album.getFeedBatchLink();
	}

	public Generator getGenerator() {
		return album.getGenerator();
	}

	public Box getGeoBoundingBox() {
		return album.getGeoBoundingBox();
	}

	public Point getGeoLocation() {
		return album.getGeoLocation();
	}

	public String getGphotoId() {
		return album.getGphotoId();
	}

	public ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) throws ParseException {
		return album.getHandler(p, namespace, localName, attrs);
	}

	public Link getHtmlLink() {
		return album.getHtmlLink();
	}

	public String getIcon() {
		return album.getIcon();
	}

	public String getId() {
		return album.getId();
	}

	public int getItemsPerPage() {
		return album.getItemsPerPage();
	}

	public Link getLink(String arg0, String arg1) {
		return album.getLink(arg0, arg1);
	}

	public List<Link> getLinks() {
		return album.getLinks();
	}

	public List<Link> getLinks(String arg0, String arg1) {
		return album.getLinks(arg0, arg1);
	}

	public String getLocation() {
		return album.getLocation();
	}

	public String getLogo() {
		return album.getLogo();
	}

	public List<MediaCategory> getMediaCategories() {
		return album.getMediaCategories();
	}

	public List<MediaContent> getMediaContents() {
		return album.getMediaContents();
	}

	public List<MediaCredit> getMediaCredits() {
		return album.getMediaCredits();
	}

	public MediaGroup getMediaGroup() {
		return album.getMediaGroup();
	}

	public MediaKeywords getMediaKeywords() {
		return album.getMediaKeywords();
	}

	public List<MediaThumbnail> getMediaThumbnails() {
		return album.getMediaThumbnails();
	}

	public String getName() {
		return album.getName();
	}

	public Link getNextLink() {
		return album.getNextLink();
	}

	public String getNickname() {
		return album.getNickname();
	}

	public Integer getPhotosLeft() throws ServiceException {
		return album.getPhotosLeft();
	}

	public Integer getPhotosUsed() throws ServiceException {
		return album.getPhotosUsed();
	}

	public Link getPreviousLink() {
		return album.getPreviousLink();
	}

	public <T extends Extension> List<T> getRepeatingExtension(Class<T> extensionClass) {
		return album.getRepeatingExtension(extensionClass);
	}

	public Collection<List<Extension>> getRepeatingExtensions() {
		return album.getRepeatingExtensions();
	}

	public TextConstruct getRights() {
		return album.getRights();
	}

	public AlbumFeed getSelf() throws IOException, ServiceException {
		return album.getSelf();
	}

	public Link getSelfLink() {
		return album.getSelfLink();
	}

	public Service getService() {
		return album.getService();
	}

	public int getStartIndex() {
		return album.getStartIndex();
	}

	public TextConstruct getSubtitle() {
		return album.getSubtitle();
	}

	public List<TagEntry> getTagEntries() {
		return album.getTagEntries();
	}

	public TextConstruct getTitle() {
		return album.getTitle();
	}

	public int getTotalResults() {
		return album.getTotalResults();
	}

	public DateTime getUpdated() {
		return album.getUpdated();
	}

	public String getUsername() {
		return album.getUsername();
	}

	public XmlBlob getXmlBlob() {
		return album.getXmlBlob();
	}

	public final <T extends Extension> boolean hasExtension(Class<T> extensionClass) {
		return album.hasExtension(extensionClass);
	}

	@Override
	public int hashCode() {
		return album.hashCode();
	}

	public final <T extends Extension> boolean hasRepeatingExtension(Class<T> extensionClass) {
		return album.hasRepeatingExtension(extensionClass);
	}

	public GphotoEntry insert(MediaSource media) throws ServiceException, IOException {
		return album.insert(media);
	}

	public <T extends GphotoEntry> T insert(T newEntry) throws ServiceException, IOException {
		return album.insert(newEntry);
	}

	public PhotoEntry insertPhoto(MediaSource photoSource) throws ServiceException, IOException {
		return album.insertPhoto(photoSource);
	}

	public final boolean isImmutable() {
		return album.isImmutable();
	}

	public void parseAtom(ExtensionProfile extProfile, InputStream input) throws IOException, ParseException {
		album.parseAtom(extProfile, input);
	}

	public void parseAtom(ExtensionProfile extProfile, Reader reader) throws IOException, ParseException {
		album.parseAtom(extProfile, reader);
	}

	public void parseAtom(ExtensionProfile extProfile, XmlEventSource source) throws IOException, ParseException {
		album.parseAtom(extProfile, source);
	}

	public void parseCumulativeXmlBlob(XmlBlob blob, ExtensionProfile extProfile, Class<? extends ExtensionPoint> extendedClass) throws IOException,
			ParseException {
		album.parseCumulativeXmlBlob(blob, extProfile, extendedClass);
	}

	public void removeExtension(Class<? extends Extension> extensionClass) {
		album.removeExtension(extensionClass);
	}

	public void removeExtension(Extension ext) {
		album.removeExtension(ext);
	}

	public void removeLinks(String arg0, String arg1) {
		album.removeLinks(arg0, arg1);
	}

	public void removeRepeatingExtension(Extension ext) {
		album.removeRepeatingExtension(ext);
	}

	public void setAccess(String access) {
		album.setAccess(access);
	}

	public void setBytesUsed(Long bytesUsed) {
		album.setBytesUsed(bytesUsed);
	}

	public void setCanPost(boolean v) {
		album.setCanPost(v);
	}

	public void setCommentCount(Integer commentCount) {
		album.setCommentCount(commentCount);
	}

	public void setCommentsEnabled(Boolean commentsEnabled) {
		album.setCommentsEnabled(commentsEnabled);
	}

	public void setDate(Date date) {
		album.setDate(date);
	}

	public void setDescription(TextConstruct description) {
		album.setDescription(description);
	}

	public void setEntries(List<GphotoEntry> entryList) {
		album.setEntries(entryList);
	}

	public void setEtag(String v) {
		album.setEtag(v);
	}

	public void setExtension(Extension ext) {
		album.setExtension(ext);
	}

	public void setGenerator(Generator v) {
		album.setGenerator(v);
	}

	public Generator setGenerator(String version, String uri, String name) {
		return album.setGenerator(version, uri, name);
	}

	public void setGeoBoundingBox(Box boundingBox) {
		album.setGeoBoundingBox(boundingBox);
	}

	public void setGeoBoundingBox(Point lowerLeft, Point upperRight) {
		album.setGeoBoundingBox(lowerLeft, upperRight);
	}

	public void setGeoLocation(Double lat, Double lon) throws IllegalArgumentException {
		album.setGeoLocation(lat, lon);
	}

	public void setGeoLocation(Point point) {
		album.setGeoLocation(point);
	}

	public void setGphotoId(Long id) {
		album.setGphotoId(id);
	}

	public void setGphotoId(String id) {
		album.setGphotoId(id);
	}

	public void setIcon(String v) {
		album.setIcon(v);
	}

	public void setId(String v) {
		album.setId(v);
	}

	public final void setImmutable(boolean isImmutable) {
		album.setImmutable(isImmutable);
	}

	public void setItemsPerPage(int v) {
		album.setItemsPerPage(v);
	}

	public void setKeywords(MediaKeywords keywords) {
		album.setKeywords(keywords);
	}

	public void setLocation(String location) {
		album.setLocation(location);
	}

	public void setLogo(String v) {
		album.setLogo(v);
	}

	public void setName(String name) {
		album.setName(name);
	}

	public void setNickname(String nickname) {
		album.setNickname(nickname);
	}

	public void setPhotosLeft(Integer photosLeft) {
		album.setPhotosLeft(photosLeft);
	}

	public void setPhotosUsed(Integer photosUsed) {
		album.setPhotosUsed(photosUsed);
	}

	public void setRights(TextConstruct v) {
		album.setRights(v);
	}

	public void setService(Service v) {
		album.setService(v);
	}

	public void setStartIndex(int v) {
		album.setStartIndex(v);
	}

	public void setSubtitle(TextConstruct v) {
		album.setSubtitle(v);
	}

	public void setTitle(TextConstruct v) {
		album.setTitle(v);
	}

	public void setTotalResults(int v) {
		album.setTotalResults(v);
	}

	public void setUpdated(DateTime v) {
		album.setUpdated(v);
	}

	public void setUsername(String username) {
		album.setUsername(username);
	}

	public void setXmlBlob(XmlBlob xmlBlob) {
		album.setXmlBlob(xmlBlob);
	}

	@Override
	public String toString() {
		return album.toString();
	}

	public void visit(ExtensionVisitor ev, ExtensionPoint parent) throws StoppedException {
		album.visit(ev, parent);
	}
}
