package cz.geek.picasa;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

import org.xml.sax.Attributes;

import com.google.gdata.client.Service;
import com.google.gdata.data.Category;
import com.google.gdata.data.Content;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.Link;
import com.google.gdata.data.Person;
import com.google.gdata.data.PubControl;
import com.google.gdata.data.Source;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.TextContent;
import com.google.gdata.data.XmlEventSource;
import com.google.gdata.data.ExtensionVisitor.StoppedException;
import com.google.gdata.data.Kind.Adaptor;
import com.google.gdata.data.Kind.AdaptorException;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.impl.GeoRssBox;
import com.google.gdata.data.geo.impl.GeoRssPoint;
import com.google.gdata.data.geo.impl.GeoRssWhere;
import com.google.gdata.data.geo.impl.GmlEnvelope;
import com.google.gdata.data.geo.impl.GmlPoint;
import com.google.gdata.data.geo.impl.W3CPoint;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaCredit;
import com.google.gdata.data.media.mediarss.MediaGroup;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.photos.AlbumEntry;
import com.google.gdata.data.photos.AlbumFeed;
import com.google.gdata.data.photos.GphotoAccess;
import com.google.gdata.data.photos.GphotoBytesUsed;
import com.google.gdata.data.photos.GphotoCommentCount;
import com.google.gdata.data.photos.GphotoCommentsEnabled;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.GphotoFeed;
import com.google.gdata.data.photos.GphotoLocation;
import com.google.gdata.data.photos.GphotoName;
import com.google.gdata.data.photos.GphotoNickname;
import com.google.gdata.data.photos.GphotoPhotosLeft;
import com.google.gdata.data.photos.GphotoPhotosUsed;
import com.google.gdata.data.photos.GphotoTimestamp;
import com.google.gdata.data.photos.GphotoUsername;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser.ElementHandler;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;

public class AlbumEntryBean extends Media {
	
	private AlbumEntry album;

	public AlbumEntryBean(AlbumEntry album) {
		super(album.getMediaContents().get(0).getUrl());
		this.album = album;
	}

	public void addAdaptor(Adaptor adaptor) {
		album.addAdaptor(adaptor);
	}

	public void addExtension(Extension ext) {
		album.addExtension(ext);
	}

	public void addHtmlLink(String htmlUri, String lang, String title) {
		album.addHtmlLink(htmlUri, lang, title);
	}

	public void addLink(Link link) {
		album.addLink(link);
	}

	public Link addLink(String rel, String type, String href) {
		return album.addLink(rel, type, href);
	}

	public void addRepeatingExtension(Extension ext) {
		album.addRepeatingExtension(ext);
	}

	public void clearGeoBoundingBox() {
		album.clearGeoBoundingBox();
	}

	public void clearPoint() {
		album.clearPoint();
	}

	public void declareExtensions(ExtensionProfile extProfile) {
		album.declareExtensions(extProfile);
	}

	public void delete() throws IOException, ServiceException {
		album.delete();
	}

	@Override
	public boolean equals(Object obj) {
		return album.equals(obj);
	}

	public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
		album.generate(w, p);
	}

	public void generateAtom(XmlWriter arg0, ExtensionProfile arg1) throws IOException {
		album.generateAtom(arg0, arg1);
	}

	public XmlBlob generateCumulativeXmlBlob(ExtensionProfile arg0) throws IOException {
		return album.generateCumulativeXmlBlob(arg0);
	}

	public void generateRss(XmlWriter w, ExtensionProfile extProfile) throws IOException {
		album.generateRss(w, extProfile);
	}

	public String getAccess() {
		return album.getAccess();
	}

	public GphotoAccess getAccessExt() {
		return album.getAccessExt();
	}

	public GphotoEntry<?> getAdaptedEntry() throws AdaptorException {
		return album.getAdaptedEntry();
	}

	public <A extends Adaptor> A getAdaptor(Class<A> adaptorClass) {
		return album.getAdaptor(adaptorClass);
	}

	public Collection<Adaptor> getAdaptors() {
		return album.getAdaptors();
	}

	public List<Person> getAuthors() {
		return album.getAuthors();
	}

	public Long getBytesUsed() {
		return album.getBytesUsed();
	}

	public GphotoBytesUsed getBytesUsedExt() {
		return album.getBytesUsedExt();
	}

	public boolean getCanEdit() {
		return album.getCanEdit();
	}

	public Set<Category> getCategories() {
		return album.getCategories();
	}

	public Integer getCommentCount() {
		return album.getCommentCount();
	}

	public GphotoCommentCount getCommentCountExt() {
		return album.getCommentCountExt();
	}

	public Boolean getCommentsEnabled() {
		return album.getCommentsEnabled();
	}

	public GphotoCommentsEnabled getCommentsEnabledExt() {
		return album.getCommentsEnabledExt();
	}

	public Content getContent() {
		return album.getContent();
	}

	public List<Person> getContributors() {
		return album.getContributors();
	}

	public Date getDate() {
		return album.getDate();
	}

	public GphotoTimestamp getDateExt() {
		return album.getDateExt();
	}

	public TextConstruct getDescription() {
		return album.getDescription();
	}

	public DateTime getEdited() {
		return album.getEdited();
	}

	public Link getEditLink() {
		return album.getEditLink();
	}

	public String getEtag() {
		return album.getEtag();
	}

	public <T extends Extension> T getExtension(Class<T> extensionClass) {
		return album.getExtension(extensionClass);
	}

	public final String getExtensionLocalName() {
		return album.getExtensionLocalName();
	}

	public final XmlNamespace getExtensionNamespace() {
		return album.getExtensionNamespace();
	}

	public Collection<Extension> getExtensions() {
		return album.getExtensions();
	}

	public <F extends GphotoFeed<F>> F getFeed(Class<F> feedClass, String... kinds) throws IOException, ServiceException {
		return album.getFeed(feedClass, kinds);
	}

	public AlbumFeed getFeed(String... kinds) throws IOException, ServiceException {
		return album.getFeed(kinds);
	}

	public Link getFeedLink() {
		return album.getFeedLink();
	}

	public Box getGeoBoundingBox() {
		return album.getGeoBoundingBox();
	}

	public Point getGeoLocation() {
		return album.getGeoLocation();
	}

	public W3CPoint getGeoPoint() {
		return album.getGeoPoint();
	}

	public GeoRssBox getGeoRssBox() {
		return album.getGeoRssBox();
	}

	public GeoRssPoint getGeoRssPoint() {
		return album.getGeoRssPoint();
	}

	public GeoRssWhere getGeoRssWhere() {
		return album.getGeoRssWhere();
	}

	public GmlEnvelope getGmlEnvelope() {
		return album.getGmlEnvelope();
	}

	public GmlPoint getGmlPoint() {
		return album.getGmlPoint();
	}

	public String getGphotoId() {
		return album.getGphotoId();
	}

	public ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) {
		return album.getHandler(p, namespace, localName, attrs);
	}

	public Link getHtmlLink() {
		return album.getHtmlLink();
	}

	public String getId() {
		return album.getId();
	}

	public Link getLink(String arg0, String arg1) {
		return album.getLink(arg0, arg1);
	}

	public List<Link> getLinks() {
		return album.getLinks();
	}

	public List<Link> getLinks(String arg0, String arg1) {
		return album.getLinks(arg0, arg1);
	}

	public String getLocation() {
		return album.getLocation();
	}

	public GphotoLocation getLocationExt() {
		return album.getLocationExt();
	}

	public List<MediaCategory> getMediaCategories() {
		return album.getMediaCategories();
	}

	public List<MediaContent> getMediaContents() {
		return album.getMediaContents();
	}

	public List<MediaCredit> getMediaCredits() {
		return album.getMediaCredits();
	}

	public Link getMediaEditLink() {
		return album.getMediaEditLink();
	}

	public MediaGroup getMediaGroup() {
		return album.getMediaGroup();
	}

	public MediaKeywords getMediaKeywords() {
		return album.getMediaKeywords();
	}

	public MediaSource getMediaSource() {
		return album.getMediaSource();
	}

	public List<MediaThumbnail> getMediaThumbnails() {
		return album.getMediaThumbnails();
	}

	public String getName() {
		return album.getName();
	}

	public GphotoName getNameExt() {
		return album.getNameExt();
	}

	public String getNickname() {
		return album.getNickname();
	}

	public GphotoNickname getNicknameExt() {
		return album.getNicknameExt();
	}

	public Integer getPhotosLeft() {
		return album.getPhotosLeft();
	}

	public GphotoPhotosLeft getPhotosLeftExt() {
		return album.getPhotosLeftExt();
	}

	public Integer getPhotosUsed() {
		return album.getPhotosUsed();
	}

	public GphotoPhotosUsed getPhotosUsedExt() {
		return album.getPhotosUsedExt();
	}

	public String getPlainTextContent() {
		return album.getPlainTextContent();
	}

	public PubControl getPubControl() {
		return album.getPubControl();
	}

	public DateTime getPublished() {
		return album.getPublished();
	}

	public <T extends Extension> List<T> getRepeatingExtension(Class<T> extensionClass) {
		return album.getRepeatingExtension(extensionClass);
	}

	public Collection<List<Extension>> getRepeatingExtensions() {
		return album.getRepeatingExtensions();
	}

	public TextConstruct getRights() {
		return album.getRights();
	}

	public AlbumEntry getSelf() throws IOException, ServiceException {
		return album.getSelf();
	}

	public Link getSelfLink() {
		return album.getSelfLink();
	}

	public Service getService() {
		return album.getService();
	}

	public Source getSource() {
		return album.getSource();
	}

	public TextConstruct getSummary() {
		return album.getSummary();
	}

	public TextContent getTextContent() {
		return album.getTextContent();
	}

	public TextConstruct getTitle() {
		return album.getTitle();
	}

	public DateTime getUpdated() {
		return album.getUpdated();
	}

	public String getUsername() {
		return album.getUsername();
	}

	public GphotoUsername getUsernameExt() {
		return album.getUsernameExt();
	}

	public String getVersionId() {
		return album.getVersionId();
	}

	public XmlBlob getXmlBlob() {
		return album.getXmlBlob();
	}

	public boolean hasAccessExt() {
		return album.hasAccessExt();
	}

	public boolean hasBytesUsedExt() {
		return album.hasBytesUsedExt();
	}

	public boolean hasCommentCountExt() {
		return album.hasCommentCountExt();
	}

	public boolean hasCommentsEnabledExt() {
		return album.hasCommentsEnabledExt();
	}

	public boolean hasDateExt() {
		return album.hasDateExt();
	}

	public final <T extends Extension> boolean hasExtension(Class<T> extensionClass) {
		return album.hasExtension(extensionClass);
	}

	public boolean hasGeoPoint() {
		return album.hasGeoPoint();
	}

	public boolean hasGeoRssBox() {
		return album.hasGeoRssBox();
	}

	public boolean hasGeoRssPoint() {
		return album.hasGeoRssPoint();
	}

	public boolean hasGeoRssWhere() {
		return album.hasGeoRssWhere();
	}

	public boolean hasGmlEnvelope() {
		return album.hasGmlEnvelope();
	}

	public boolean hasGmlPoint() {
		return album.hasGmlPoint();
	}

	@Override
	public int hashCode() {
		return album.hashCode();
	}

	public boolean hasLocationExt() {
		return album.hasLocationExt();
	}

	public boolean hasMediaGroup() {
		return album.hasMediaGroup();
	}

	public boolean hasNameExt() {
		return album.hasNameExt();
	}

	public boolean hasNicknameExt() {
		return album.hasNicknameExt();
	}

	public boolean hasPhotosLeftExt() {
		return album.hasPhotosLeftExt();
	}

	public boolean hasPhotosUsedExt() {
		return album.hasPhotosUsedExt();
	}

	public final <T extends Extension> boolean hasRepeatingExtension(Class<T> extensionClass) {
		return album.hasRepeatingExtension(extensionClass);
	}

	public boolean hasUsernameExt() {
		return album.hasUsernameExt();
	}

	public boolean isDraft() {
		return album.isDraft();
	}

	public final boolean isImmutable() {
		return album.isImmutable();
	}

	public void parseAtom(ExtensionProfile extProfile, InputStream input) throws IOException, ParseException {
		album.parseAtom(extProfile, input);
	}

	public void parseAtom(ExtensionProfile extProfile, Reader reader) throws IOException, ParseException {
		album.parseAtom(extProfile, reader);
	}

	public void parseAtom(ExtensionProfile extProfile, XmlEventSource eventSource) throws IOException, ParseException {
		album.parseAtom(extProfile, eventSource);
	}

	public void parseCumulativeXmlBlob(XmlBlob blob, ExtensionProfile extProfile, Class<? extends ExtensionPoint> extendedClass) throws IOException,
			ParseException {
		album.parseCumulativeXmlBlob(blob, extProfile, extendedClass);
	}

	public void removeExtension(Class<? extends Extension> extensionClass) {
		album.removeExtension(extensionClass);
	}

	public void removeExtension(Extension ext) {
		album.removeExtension(ext);
	}

	public void removeLinks(String arg0, String arg1) {
		album.removeLinks(arg0, arg1);
	}

	public void removeRepeatingExtension(Extension ext) {
		album.removeRepeatingExtension(ext);
	}

	public void setAccess(String access) {
		album.setAccess(access);
	}

	public void setAccessExt(GphotoAccess accessExt) {
		album.setAccessExt(accessExt);
	}

	public void setBytesUsed(Long bytesUsed) {
		album.setBytesUsed(bytesUsed);
	}

	public void setBytesUsedExt(GphotoBytesUsed bytesUsedExt) {
		album.setBytesUsedExt(bytesUsedExt);
	}

	public void setCanEdit(boolean v) {
		album.setCanEdit(v);
	}

	public void setCommentCount(Integer commentCount) {
		album.setCommentCount(commentCount);
	}

	public void setCommentCountExt(GphotoCommentCount commentCountExt) {
		album.setCommentCountExt(commentCountExt);
	}

	public void setCommentsEnabled(Boolean commentsEnabled) {
		album.setCommentsEnabled(commentsEnabled);
	}

	public void setCommentsEnabledExt(GphotoCommentsEnabled commentsEnabledExt) {
		album.setCommentsEnabledExt(commentsEnabledExt);
	}

	public void setContent(Content v) {
		album.setContent(v);
	}

	public void setContent(TextConstruct tc) {
		album.setContent(tc);
	}

	public void setDate(Date date) {
		album.setDate(date);
	}

	public void setDateExt(GphotoTimestamp dateExt) {
		album.setDateExt(dateExt);
	}

	public void setDescription(TextConstruct description) {
		album.setDescription(description);
	}

	public void setDraft(Boolean v) {
		album.setDraft(v);
	}

	public void setEdited(DateTime v) {
		album.setEdited(v);
	}

	public void setEtag(String v) {
		album.setEtag(v);
	}

	public void setExtension(Extension ext) {
		album.setExtension(ext);
	}

	public void setGeoBoundingBox(Box boundingBox) {
		album.setGeoBoundingBox(boundingBox);
	}

	public void setGeoBoundingBox(Point lowerLeft, Point upperRight) {
		album.setGeoBoundingBox(lowerLeft, upperRight);
	}

	public void setGeoLocation(Double lat, Double lon) throws IllegalArgumentException {
		album.setGeoLocation(lat, lon);
	}

	public void setGeoLocation(Point point) {
		album.setGeoLocation(point);
	}

	public void setGeoPoint(W3CPoint geoPoint) {
		album.setGeoPoint(geoPoint);
	}

	public void setGeoRssBox(GeoRssBox geoRssBox) {
		album.setGeoRssBox(geoRssBox);
	}

	public void setGeoRssPoint(GeoRssPoint geoRssPoint) {
		album.setGeoRssPoint(geoRssPoint);
	}

	public void setGeoRssWhere(GeoRssWhere geoRssWhere) {
		album.setGeoRssWhere(geoRssWhere);
	}

	public void setGmlEnvelope(GmlEnvelope gmlEnvelope) {
		album.setGmlEnvelope(gmlEnvelope);
	}

	public void setGmlPoint(GmlPoint gmlPoint) {
		album.setGmlPoint(gmlPoint);
	}

	public void setGphotoId(Long id) {
		album.setGphotoId(id);
	}

	public void setGphotoId(String id) {
		album.setGphotoId(id);
	}

	public void setId(String v) {
		album.setId(v);
	}

	public final void setImmutable(boolean isImmutable) {
		album.setImmutable(isImmutable);
	}

	public void setKeywords(MediaKeywords keywords) {
		album.setKeywords(keywords);
	}

	public void setLocation(String location) {
		album.setLocation(location);
	}

	public void setLocationExt(GphotoLocation locationExt) {
		album.setLocationExt(locationExt);
	}

	public void setMediaGroup(MediaGroup mediaGroup) {
		album.setMediaGroup(mediaGroup);
	}

	public void setMediaSource(MediaSource arg0) {
		album.setMediaSource(arg0);
	}

	public void setName(String name) {
		album.setName(name);
	}

	public void setNameExt(GphotoName nameExt) {
		album.setNameExt(nameExt);
	}

	public void setNickname(String nickname) {
		album.setNickname(nickname);
	}

	public void setNicknameExt(GphotoNickname nicknameExt) {
		album.setNicknameExt(nicknameExt);
	}

	public void setPhotosLeft(Integer photosLeft) {
		album.setPhotosLeft(photosLeft);
	}

	public void setPhotosLeftExt(GphotoPhotosLeft photosLeftExt) {
		album.setPhotosLeftExt(photosLeftExt);
	}

	public void setPhotosUsed(Integer photosUsed) {
		album.setPhotosUsed(photosUsed);
	}

	public void setPhotosUsedExt(GphotoPhotosUsed photosUsedExt) {
		album.setPhotosUsedExt(photosUsedExt);
	}

	public void setPubControl(PubControl value) {
		album.setPubControl(value);
	}

	public void setPublished(DateTime v) {
		album.setPublished(v);
	}

	public void setRights(TextConstruct v) {
		album.setRights(v);
	}

	public void setService(Service v) {
		album.setService(v);
	}

	public void setSource(Source v) {
		album.setSource(v);
	}

	public void setSummary(TextConstruct v) {
		album.setSummary(v);
	}

	public void setTitle(TextConstruct v) {
		album.setTitle(v);
	}

	public void setUpdated(DateTime v) {
		album.setUpdated(v);
	}

	public void setUsername(String username) {
		album.setUsername(username);
	}

	public void setUsernameExt(GphotoUsername usernameExt) {
		album.setUsernameExt(usernameExt);
	}

	public void setVersionId(String v) {
		album.setVersionId(v);
	}

	public void setXmlBlob(XmlBlob xmlBlob) {
		album.setXmlBlob(xmlBlob);
	}

	@Override
	public String toString() {
		return album.toString();
	}

	public AlbumEntry update() throws IOException, ServiceException {
		return album.update();
	}

	public AlbumEntry updateMedia(boolean updateEntry) throws IOException, ServiceException {
		return album.updateMedia(updateEntry);
	}

	public void visit(ExtensionVisitor ev, ExtensionPoint parent) throws StoppedException {
		album.visit(ev, parent);
	}
	
}
