package cz.geek.gdata.client;

import java.io.IOException;
import java.net.URL;

import com.google.gdata.client.Service.GDataRequest;
import com.google.gdata.client.Service.GDataRequest.RequestType;
import com.google.gdata.client.http.GoogleGDataRequest.Factory;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ServiceException;

import cz.geek.cache.Cache;

public class CachingRequestFactory extends Factory {

	private Cache<String, CachedResponse> cache;

	public CachingRequestFactory(Cache<String, CachedResponse> cache) {
		super();
		this.cache = cache;
	}

	@Override
	public GDataRequest getRequest(RequestType type, URL requestUrl, ContentType contentType) throws IOException, ServiceException {
		return new CachedRequest(cache, type, requestUrl, contentType, authToken, headerMap, privateHeaderMap, connectionSource);
	}

}
