package cz.geek.picasa;

import java.io.File;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public class Media {

	// http://code.google.com/intl/cs/apis/picasaweb/reference.html#Parameters
	
	protected static final int[] size = new int[]{ 
		32, 48, 64, 72, 144, 160, 
		200, 288, 320, 400, 512, 576, 640, 720, 800,
		912, 1024, 1152, 1280, 1440, 1600 };
	protected Map<String, String> media = new LinkedHashMap<String, String>(size.length);
	protected Map<String, String> mediac = new LinkedHashMap<String, String>(size.length);
	protected String name;

	public Media(final String url) {
		setMedia(url);
	}

	public Map<String, String> getMedia() {
		return media;
	}

	public Map<String, String> getMediac() {
		return mediac;
	}

	protected void setMedia(final String url) {
		URI uri = URI.create(url);
		File f = new File(uri.getRawPath());
		name = f.getName();
		for (int i: size) {
			String key = Integer.toString(i);
			media.put(key,  uri.resolve("s" + i + "/" + name).toString());
			mediac.put(key, uri.resolve("s" + i + "-c/" + name).toString());
		}
	}

	public String getName() {
		return name;
	}

}