package cz.geek.gdata.contacts;

import java.net.MalformedURLException;
import java.net.URL;

import com.google.gdata.client.contacts.ContactsService;
import com.google.gdata.data.contacts.ContactEntry;

import cz.geek.gdata.GdataException;

public class Contacts {

	public static final String URL = "http://www.google.com/m8/feeds/contacts/default/full";
	protected final URL url;
	
	protected ContactsService service;

	public Contacts(ContactsService service) {
		this.service = service;
		try {
			url = new URL(URL);
		} catch (MalformedURLException e) {
			throw new GdataException(e);
		}
	}

	public ContactEntry insert(ContactEntry contact) {
		try {
			return service.insert(url, contact);
		} catch (Exception e) {
			throw new GdataException(e);
		}
	}
}
