/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.picasa;

import com.google.gdata.client.photos.PicasawebService;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.photos.AlbumEntry;
import com.google.gdata.data.photos.AlbumFeed;
import com.google.gdata.data.photos.PhotoEntry;
import com.google.gdata.data.photos.UserFeed;
import cz.geek.picasa.AlbumBean;
import cz.geek.picasa.PhotosBean;
import cz.geek.picasa.PicasaWebException;
import cz.geek.picasa.ResourceNotFoundException;
import cz.geek.picasa.UserBean;
import cz.geek.picasa.Visibility;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicasaWeb {
    private static final String USER_URL = "http://picasaweb.google.com/data/feed/api/user/%s";
    private static final String ALBID_URL = "http://picasaweb.google.com/data/feed/api/user/%s/albumid/%s";
    private static final String ALB_URL = "http://picasaweb.google.com/data/feed/api/user/%s/album/%s";
    private static final String PHOTO_URL = "http://picasaweb.google.com/data/entry/api/user/%s/album/%s/photoid/%s";
    public static final String ALBUM_URL = "http://picasaweb.google.com/data/feed/api/user/%s?kind=album&access=%s";
    public static final String PHOTOS_URL = "http://picasaweb.google.com/data/feed/api/user/%s/album/%s?kind=photo";
    protected PicasawebService pws;

    public PicasaWeb(PicasawebService pws) {
        this.pws = pws;
    }

    protected PicasaWebException exception(Exception e) {
        if (e instanceof com.google.gdata.util.ResourceNotFoundException) {
            return new ResourceNotFoundException(e);
        }
        return new PicasaWebException(e);
    }

    public UserFeed getUserFeed(String user, Visibility visibility) {
        if (user == null) {
            throw new PicasaWebException("User can not be null");
        }
        try {
            URL albumsUrl = new URL(String.format(ALBUM_URL, user, visibility.toString().toLowerCase()));
            return (UserFeed)this.pws.getFeed(albumsUrl, UserFeed.class);
        }
        catch (Exception e) {
            throw this.exception(e);
        }
    }

    public UserBean getUser(String user) {
        return this.getUser(user, Visibility.PUBLIC);
    }

    public UserBean getUser(String user, Visibility visibility) {
        UserFeed userFeed = this.getUserFeed(user, visibility);
        return new UserBean(userFeed);
    }

    public AlbumFeed getAlbumFeed(String user, String album) {
        try {
            URL albumAndPhotosUrl = new URL(String.format(PHOTOS_URL, user, album));
            return (AlbumFeed)this.pws.getFeed(albumAndPhotosUrl, AlbumFeed.class);
        }
        catch (Exception e) {
            throw this.exception(e);
        }
    }

    public AlbumBean getAlbum(String user, String album) {
        AlbumFeed a = this.getAlbumFeed(user, album);
        return new AlbumBean(a);
    }

    public PhotosBean photo(AlbumFeed albumFeed, String photo) {
        int size;
        int c = 0;
        PhotoEntry prev = null;
        PhotoEntry next = null;
        PhotoEntry curr = null;
        for (PhotoEntry i : albumFeed.getPhotoEntries()) {
            if (photo.equals(i.getTitle().getPlainText())) {
                curr = i;
                break;
            }
            ++c;
            prev = i;
        }
        if (c + 1 < (size = albumFeed.getPhotoEntries().size())) {
            next = (PhotoEntry)albumFeed.getPhotoEntries().get(c + 1);
        }
        return new PhotosBean(curr, c, prev, next, size);
    }

    public PhotosBean getPhoto(String user, String album, String photo) {
        AlbumFeed a = this.getAlbumFeed(user, album);
        return this.photo(a, photo);
    }

    public PhotoEntry insert(String user, String album, MediaSource source) {
        try {
            URL url = new URL(String.format(ALB_URL, user, album));
            return (PhotoEntry)this.pws.insert(url, PhotoEntry.class, source);
        }
        catch (Exception e) {
            throw this.exception(e);
        }
    }

    public AlbumEntry createAlbum(String user, AlbumEntry album) {
        try {
            URL url = new URL(String.format(USER_URL, user));
            return (AlbumEntry)this.pws.insert(url, (IEntry)album);
        }
        catch (Exception e) {
            throw this.exception(e);
        }
    }

    public AlbumEntry createAlbum(String album) {
        AlbumEntry a = new AlbumEntry();
        a.setTitle((TextConstruct)new PlainTextConstruct(album));
        return this.createAlbum("default", a);
    }

    public PhotoEntry getPhotoEntryByUserAlbumPhotoid(String user, String album, String photoid) {
        try {
            URL url = new URL(String.format(PHOTO_URL, user, album, photoid));
            return (PhotoEntry)this.pws.getEntry(url, PhotoEntry.class);
        }
        catch (Exception e) {
            throw this.exception(e);
        }
    }

    public void update(BaseEntry<?> entry) {
        try {
            entry.update();
        }
        catch (Exception e) {
            throw this.exception(e);
        }
    }

    public PhotoEntry updateMedia(PhotoEntry entry, boolean updateEntry) {
        try {
            return (PhotoEntry)entry.updateMedia(updateEntry);
        }
        catch (Exception e) {
            throw this.exception(e);
        }
    }
}

