/*
 * Decompiled with CFR 0.152.
 */
package cz.geek.gdata.client;

import com.google.gdata.client.Service;
import com.google.gdata.client.http.GoogleGDataRequest;
import com.google.gdata.client.http.HttpAuthToken;
import com.google.gdata.client.http.HttpUrlConnectionSource;
import com.google.gdata.data.DateTime;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ServiceException;
import cz.geek.cache.Cache;
import cz.geek.gdata.client.CachedResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedRequest
extends GoogleGDataRequest {
    protected Cache<String, CachedResponse> cache;
    protected CachedResponse resp;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected CachedRequest(Cache<String, CachedResponse> cache, Service.GDataRequest.RequestType type, URL requestUrl, ContentType contentType, HttpAuthToken authToken, Map<String, String> headerMap, Map<String, String> privateHeaderMap, HttpUrlConnectionSource connectionSource) throws IOException {
        super(type, requestUrl, contentType, authToken, headerMap, privateHeaderMap, connectionSource);
        this.cache = cache;
    }

    public void execute() throws IOException, ServiceException {
        String url = this.requestUrl.toString();
        if (!this.cache.containsKey((Serializable)((Object)url))) {
            this.log.debug("execute()");
            super.execute();
            this.log.info("Storing {} to cache", (Object)url);
            InputStream in = super.getResponseStream();
            Map<String, List<String>> headers = this.httpConn.getHeaderFields();
            this.resp = new CachedResponse(in, headers);
            this.cache.put((Serializable)((Object)url), (Serializable)this.resp);
        } else {
            this.log.debug("execute() skipping");
            this.resp = (CachedResponse)this.cache.get((Serializable)((Object)url));
        }
    }

    public InputStream getResponseStream() throws IOException {
        String url = this.requestUrl.toString();
        this.log.info("getResponseStream() {} from cache", (Object)url);
        return this.resp.getResponseStream();
    }

    public String getResponseHeader(String headerName) {
        String url = this.requestUrl.toString();
        this.log.info("getResponseHeader() {} from cache", (Object)url);
        String value = this.resp.getHeaderField(headerName);
        return value;
    }

    public ContentType getResponseContentType() {
        String value = this.getResponseHeader("Content-Type");
        if (value == null) {
            return null;
        }
        return new ContentType(value);
    }

    public DateTime getResponseDateHeader(String headerName) {
        String url = this.requestUrl.toString();
        this.log.info("getResponseDateHeader() {} from cache", (Object)url);
        long dateValue = this.resp.getHeaderFieldDate(headerName, -1);
        return dateValue >= 0L ? new DateTime(dateValue) : null;
    }
}

