package cz.geek.picasa;

import java.net.URL;

import com.google.gdata.client.photos.PicasawebService;
import com.google.gdata.data.photos.AlbumFeed;
import com.google.gdata.data.photos.PhotoEntry;
import com.google.gdata.data.photos.UserFeed;

/**
 * This class simplifies using of {@link PicasawebService} by providing simple convinient methods.
 * @author martin
 */
public class PicasaWeb {
	public static final String ALBUM_URL = "http://picasaweb.google.com/data/feed/api/user/%s?kind=album&access=%s";
	public static final String PHOTOS_URL = "http://picasaweb.google.com/data/feed/api/user/%s/album/%s?kind=photo";

	protected PicasawebService pws;

	public PicasaWeb(PicasawebService pws) {
		super();
		this.pws = pws;
	}
	
	protected PicasaWebException exception(Exception e) {
		if (e instanceof com.google.gdata.util.ResourceNotFoundException)
			return new ResourceNotFoundException(e);
		else
			return new PicasaWebException(e);
	}

	public UserFeed getUserFeed(String user, Visibility visibility) {
		if (user == null)
			throw new PicasaWebException("User can not be null");
		try {
			URL albumsUrl = new URL(String.format(ALBUM_URL, user, visibility.toString().toLowerCase()));
			// Send the request for the user's albums.
			return pws.getFeed(albumsUrl, UserFeed.class);
		} catch (Exception e) {
			throw exception(e);
		}
	}
	
	public UserBean getUser(String user) {
		return getUser(user, Visibility.PUBLIC);
	}
	
	public UserBean getUser(String user, Visibility visibility) {
		UserFeed userFeed = getUserFeed(user, visibility);
		return new UserBean(userFeed);
	}
	
	public AlbumFeed getAlbumFeed(String user, String album) {
		try {
			URL albumAndPhotosUrl = new URL(String.format(PHOTOS_URL, user, album));
			return pws.getFeed(albumAndPhotosUrl, AlbumFeed.class);
		} catch (Exception e) {
			throw exception(e);
		}
	}
	
	public AlbumBean getAlbum(String user, String album) {
		AlbumFeed a = getAlbumFeed(user, album);
		return new AlbumBean(a);
	}

	public PhotosBean photo(AlbumFeed albumFeed, String photo) {
		int c = 0;
		PhotoEntry prev = null;
		PhotoEntry next = null;
		PhotoEntry curr = null;
		for (PhotoEntry i : albumFeed.getPhotoEntries()) {
			if (photo.equals(i.getTitle().getPlainText())) {
				curr = i;
				break;
			}
			c++;
			prev = i;
		}
		int size = albumFeed.getPhotoEntries().size();
		if (c + 1 < size)
			next = albumFeed.getPhotoEntries().get(c + 1);
		return new PhotosBean(curr, c, prev, next, size);
	}
	
	public PhotosBean getPhoto(String user, String album, String photo) {
		AlbumFeed a = getAlbumFeed(user, album);
		return photo(a, photo);
	}

}
