package cz.geek.picasa;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.xml.sax.Attributes;

import com.google.gdata.client.Service;
import com.google.gdata.data.Category;
import com.google.gdata.data.Content;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.ExtensionVisitor.StoppedException;
import com.google.gdata.data.Kind.Adaptor;
import com.google.gdata.data.Kind.AdaptorException;
import com.google.gdata.data.Link;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.Person;
import com.google.gdata.data.PubControl;
import com.google.gdata.data.Source;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.TextContent;
import com.google.gdata.data.XmlEventSource;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.XmlParser.ElementHandler;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;

public class PhotoBean extends Media {
	
	private GphotoEntry photoentry;
	
	@SuppressWarnings("rawtypes")
	protected PhotoBean(GphotoEntry i) {
		super(((MediaContent) i.getContent()).getUri());
		photoentry = i;
	}
	
	public void addAdaptor(Adaptor adaptor) {
		photoentry.addAdaptor(adaptor);
	}

	public void addExtension(Extension ext) {
		photoentry.addExtension(ext);
	}

	public void addHtmlLink(String htmlUri, String lang, String title) {
		photoentry.addHtmlLink(htmlUri, lang, title);
	}

	public void addLink(Link link) {
		photoentry.addLink(link);
	}

	public Link addLink(String rel, String type, String href) {
		return photoentry.addLink(rel, type, href);
	}

	public void addRepeatingExtension(Extension ext) {
		photoentry.addRepeatingExtension(ext);
	}

	public void declareExtensions(ExtensionProfile extProfile) {
		photoentry.declareExtensions(extProfile);
	}

	public void delete() throws IOException, ServiceException {
		photoentry.delete();
	}

	@Override
	public boolean equals(Object obj) {
		return photoentry.equals(obj);
	}

	public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
		photoentry.generate(w, p);
	}

	public void generateAtom(XmlWriter arg0, ExtensionProfile arg1) throws IOException {
		photoentry.generateAtom(arg0, arg1);
	}

	public XmlBlob generateCumulativeXmlBlob(ExtensionProfile arg0) throws IOException {
		return photoentry.generateCumulativeXmlBlob(arg0);
	}

	public void generateRss(XmlWriter w, ExtensionProfile extProfile) throws IOException {
		photoentry.generateRss(w, extProfile);
	}

	public GphotoEntry<?> getAdaptedEntry() throws AdaptorException {
		return photoentry.getAdaptedEntry();
	}

	public Collection<Adaptor> getAdaptors() {
		return photoentry.getAdaptors();
	}

	public List<Person> getAuthors() {
		return photoentry.getAuthors();
	}

	public boolean getCanEdit() {
		return photoentry.getCanEdit();
	}

	public Set<Category> getCategories() {
		return photoentry.getCategories();
	}

	public Content getContent() {
		return photoentry.getContent();
	}

	public List<Person> getContributors() {
		return photoentry.getContributors();
	}

	public TextConstruct getDescription() {
		return photoentry.getDescription();
	}

	public DateTime getEdited() {
		return photoentry.getEdited();
	}

	public Link getEditLink() {
		return photoentry.getEditLink();
	}

	public String getEtag() {
		return photoentry.getEtag();
	}

	public <T extends Extension> T getExtension(Class<T> extensionClass) {
		return photoentry.getExtension(extensionClass);
	}

	public final String getExtensionLocalName() {
		return photoentry.getExtensionLocalName();
	}

	public final XmlNamespace getExtensionNamespace() {
		return photoentry.getExtensionNamespace();
	}

	public Collection<Extension> getExtensions() {
		return photoentry.getExtensions();
	}

	public Link getFeedLink() {
		return photoentry.getFeedLink();
	}

	public String getGphotoId() {
		return photoentry.getGphotoId();
	}

	public ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) {
		return photoentry.getHandler(p, namespace, localName, attrs);
	}

	public Link getHtmlLink() {
		return photoentry.getHtmlLink();
	}

	public String getId() {
		return photoentry.getId();
	}

	public Link getLink(String arg0, String arg1) {
		return photoentry.getLink(arg0, arg1);
	}

	public List<Link> getLinks() {
		return photoentry.getLinks();
	}

	public List<Link> getLinks(String arg0, String arg1) {
		return photoentry.getLinks(arg0, arg1);
	}


	public Link getMediaEditLink() {
		return photoentry.getMediaEditLink();
	}


	public MediaSource getMediaSource() {
		return photoentry.getMediaSource();
	}

	public String getPlainTextContent() {
		return photoentry.getPlainTextContent();
	}

	public PubControl getPubControl() {
		return photoentry.getPubControl();
	}

	public DateTime getPublished() {
		return photoentry.getPublished();
	}

	public <T extends Extension> List<T> getRepeatingExtension(Class<T> extensionClass) {
		return photoentry.getRepeatingExtension(extensionClass);
	}

	public Collection<List<Extension>> getRepeatingExtensions() {
		return photoentry.getRepeatingExtensions();
	}

	public TextConstruct getRights() {
		return photoentry.getRights();
	}

	public Link getSelfLink() {
		return photoentry.getSelfLink();
	}

	public Service getService() {
		return photoentry.getService();
	}

	public Source getSource() {
		return photoentry.getSource();
	}

	public TextConstruct getSummary() {
		return photoentry.getSummary();
	}

	public TextContent getTextContent() {
		return photoentry.getTextContent();
	}

	public TextConstruct getTitle() {
		return photoentry.getTitle();
	}

	public DateTime getUpdated() {
		return photoentry.getUpdated();
	}

	public String getVersionId() {
		return photoentry.getVersionId();
	}

	public XmlBlob getXmlBlob() {
		return photoentry.getXmlBlob();
	}

	public final <T extends Extension> boolean hasExtension(Class<T> extensionClass) {
		return photoentry.hasExtension(extensionClass);
	}

	@Override
	public int hashCode() {
		return photoentry.hashCode();
	}

	public final <T extends Extension> boolean hasRepeatingExtension(Class<T> extensionClass) {
		return photoentry.hasRepeatingExtension(extensionClass);
	}

	public boolean isDraft() {
		return photoentry.isDraft();
	}

	public final boolean isImmutable() {
		return photoentry.isImmutable();
	}

	public void parseAtom(ExtensionProfile extProfile, InputStream input) throws IOException, ParseException {
		photoentry.parseAtom(extProfile, input);
	}

	public void parseAtom(ExtensionProfile extProfile, Reader reader) throws IOException, ParseException {
		photoentry.parseAtom(extProfile, reader);
	}

	public void parseAtom(ExtensionProfile extProfile, XmlEventSource eventSource) throws IOException, ParseException {
		photoentry.parseAtom(extProfile, eventSource);
	}

	public void parseCumulativeXmlBlob(XmlBlob blob, ExtensionProfile extProfile, Class<? extends ExtensionPoint> extendedClass) throws IOException,
			ParseException {
		photoentry.parseCumulativeXmlBlob(blob, extProfile, extendedClass);
	}

	public void removeExtension(Class<? extends Extension> extensionClass) {
		photoentry.removeExtension(extensionClass);
	}

	public void removeExtension(Extension ext) {
		photoentry.removeExtension(ext);
	}

	public void removeLinks(String arg0, String arg1) {
		photoentry.removeLinks(arg0, arg1);
	}

	public void removeRepeatingExtension(Extension ext) {
		photoentry.removeRepeatingExtension(ext);
	}

	public void setCanEdit(boolean v) {
		photoentry.setCanEdit(v);
	}

	public void setContent(Content v) {
		photoentry.setContent(v);
	}

	public void setContent(TextConstruct tc) {
		photoentry.setContent(tc);
	}

	public void setDescription(TextConstruct description) {
		photoentry.setDescription(description);
	}

	public void setDraft(Boolean v) {
		photoentry.setDraft(v);
	}

	public void setEdited(DateTime v) {
		photoentry.setEdited(v);
	}

	public void setEtag(String v) {
		photoentry.setEtag(v);
	}

	public void setExtension(Extension ext) {
		photoentry.setExtension(ext);
	}

	public void setGphotoId(Long id) {
		photoentry.setGphotoId(id);
	}

	public void setGphotoId(String id) {
		photoentry.setGphotoId(id);
	}

	public void setId(String v) {
		photoentry.setId(v);
	}

	public final void setImmutable(boolean isImmutable) {
		photoentry.setImmutable(isImmutable);
	}

	public void setMediaSource(MediaSource arg0) {
		photoentry.setMediaSource(arg0);
	}

	public void setPubControl(PubControl value) {
		photoentry.setPubControl(value);
	}

	public void setPublished(DateTime v) {
		photoentry.setPublished(v);
	}

	public void setRights(TextConstruct v) {
		photoentry.setRights(v);
	}

	public void setService(Service v) {
		photoentry.setService(v);
	}

	public void setSource(Source v) {
		photoentry.setSource(v);
	}

	public void setSummary(TextConstruct v) {
		photoentry.setSummary(v);
	}

	public void setTitle(TextConstruct v) {
		photoentry.setTitle(v);
	}

	public void setUpdated(DateTime v) {
		photoentry.setUpdated(v);
	}

	public void setVersionId(String v) {
		photoentry.setVersionId(v);
	}

	public void setXmlBlob(XmlBlob xmlBlob) {
		photoentry.setXmlBlob(xmlBlob);
	}

	@Override
	public String toString() {
		return photoentry.toString();
	}

	public void visit(ExtensionVisitor ev, ExtensionPoint parent) throws StoppedException {
		photoentry.visit(ev, parent);
	}
}
