package cz.geek.gdata.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.util.FileCopyUtils;

/**
 * Response stored in a cache.
 * @author martin
 */
public class CachedResponse implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	private byte[] buffer;
	
	private Map<String, List<String>> headers;

	public CachedResponse(byte[] buffer, Map<String, List<String>> headers) {
		super();
		this.buffer = buffer;
		this.headers = headers;
	}

	public CachedResponse(InputStream in, Map<String, List<String>> headers) throws IOException {
		this(FileCopyUtils.copyToByteArray(in), headers);
	}

	public InputStream getResponseStream() {
		return new ByteArrayInputStream(buffer);
	}

	public String getHeaderField(String name) {
		List<String> values = headers.get(name);
		if (values == null || values.size() == 0) return null;
		return values.get(0);
	}

	@SuppressWarnings("deprecation")
	public long getHeaderFieldDate(String name, int Default) {
		String dateString = getHeaderField(name.toLowerCase());
		try {
		    dateString.trim();
		    if (dateString.indexOf("GMT") == -1) {
		        dateString = dateString+" GMT";
		    }
		    return Date.parse(dateString);
		} catch (Exception e) {
		}
		return Default;
	}

}
