/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.impl.BoxDataImpl;
import com.google.gdata.data.geo.impl.GeoRssBox;
import com.google.gdata.data.geo.impl.GeoRssPoint;
import com.google.gdata.data.geo.impl.GeoRssWhere;
import com.google.gdata.data.geo.impl.GmlEnvelope;
import com.google.gdata.data.geo.impl.GmlPoint;
import com.google.gdata.data.geo.impl.PointDataImpl;
import com.google.gdata.data.geo.impl.W3CPoint;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaCredit;
import com.google.gdata.data.media.mediarss.MediaGroup;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.photos.AtomData;
import com.google.gdata.data.photos.ExifTags;
import com.google.gdata.data.photos.GphotoAccess;
import com.google.gdata.data.photos.GphotoAlbumId;
import com.google.gdata.data.photos.GphotoChecksum;
import com.google.gdata.data.photos.GphotoClient;
import com.google.gdata.data.photos.GphotoCommentCount;
import com.google.gdata.data.photos.GphotoCommentsEnabled;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.GphotoFeaturedDate;
import com.google.gdata.data.photos.GphotoHeight;
import com.google.gdata.data.photos.GphotoImageVersion;
import com.google.gdata.data.photos.GphotoOriginalVideo;
import com.google.gdata.data.photos.GphotoPosition;
import com.google.gdata.data.photos.GphotoRotation;
import com.google.gdata.data.photos.GphotoSize;
import com.google.gdata.data.photos.GphotoStarred;
import com.google.gdata.data.photos.GphotoStreamId;
import com.google.gdata.data.photos.GphotoTimestamp;
import com.google.gdata.data.photos.GphotoVersion;
import com.google.gdata.data.photos.GphotoVideoStatus;
import com.google.gdata.data.photos.GphotoViewCount;
import com.google.gdata.data.photos.GphotoWidth;
import com.google.gdata.data.photos.PhotoData;
import com.google.gdata.data.photos.PhotoFeed;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.xml.XmlNamespace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/photos/2007#photo")
public class PhotoEntry
extends GphotoEntry<PhotoEntry>
implements AtomData,
PhotoData {
    public static final String KIND = "http://schemas.google.com/photos/2007#photo";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/photos/2007#photo");

    public PhotoEntry() {
        this.getCategories().add(CATEGORY);
    }

    public PhotoEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(PhotoEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(PhotoEntry.class, GphotoAccess.class);
        extProfile.declare(PhotoEntry.class, GphotoAlbumId.class);
        extProfile.declare(PhotoEntry.class, GphotoChecksum.class);
        extProfile.declare(PhotoEntry.class, GphotoClient.class);
        extProfile.declare(PhotoEntry.class, GphotoCommentCount.class);
        extProfile.declare(PhotoEntry.class, new ExtensionDescription(GphotoCommentsEnabled.class, new XmlNamespace("gphoto", "http://schemas.google.com/photos/2007"), "commentingEnabled", false, false, false));
        extProfile.declare(PhotoEntry.class, new ExtensionDescription(ExifTags.class, new XmlNamespace("exif", "http://schemas.google.com/photos/exif/2007"), "tags", false, false, false));
        new ExifTags().declareExtensions(extProfile);
        extProfile.declare(PhotoEntry.class, GphotoFeaturedDate.class);
        extProfile.declare(PhotoEntry.class, new ExtensionDescription(W3CPoint.class, new XmlNamespace("geo", "http://www.w3.org/2003/01/geo/wgs84_pos#"), "Point", false, false, false));
        new W3CPoint().declareExtensions(extProfile);
        extProfile.declare(PhotoEntry.class, new ExtensionDescription(GeoRssBox.class, new XmlNamespace("georss", "http://www.georss.org/georss"), "box", false, false, false));
        extProfile.declare(PhotoEntry.class, new ExtensionDescription(GeoRssPoint.class, new XmlNamespace("georss", "http://www.georss.org/georss"), "point", false, false, false));
        extProfile.declare(PhotoEntry.class, new ExtensionDescription(GeoRssWhere.class, new XmlNamespace("georss", "http://www.georss.org/georss"), "where", false, false, false));
        new GeoRssWhere().declareExtensions(extProfile);
        extProfile.declare(PhotoEntry.class, new ExtensionDescription(GmlEnvelope.class, new XmlNamespace("gml", "http://www.opengis.net/gml"), "Envelope", false, false, false));
        new GmlEnvelope().declareExtensions(extProfile);
        extProfile.declare(PhotoEntry.class, new ExtensionDescription(GmlPoint.class, new XmlNamespace("gml", "http://www.opengis.net/gml"), "Point", false, false, false));
        new GmlPoint().declareExtensions(extProfile);
        extProfile.declare(PhotoEntry.class, GphotoHeight.class);
        extProfile.declare(PhotoEntry.class, GphotoImageVersion.class);
        extProfile.declare(PhotoEntry.class, new ExtensionDescription(MediaGroup.class, new XmlNamespace("media", "http://search.yahoo.com/mrss/"), "group", false, false, false));
        new MediaGroup().declareExtensions(extProfile);
        extProfile.declare(PhotoEntry.class, GphotoOriginalVideo.class);
        extProfile.declare(PhotoEntry.class, GphotoPosition.class);
        extProfile.declare(PhotoEntry.class, GphotoRotation.class);
        extProfile.declare(PhotoEntry.class, GphotoSize.class);
        extProfile.declare(PhotoEntry.class, GphotoStarred.class);
        extProfile.declare(PhotoEntry.class, GphotoStreamId.getDefaultDescription(false, true));
        extProfile.declare(PhotoEntry.class, GphotoTimestamp.class);
        extProfile.declare(PhotoEntry.class, GphotoVersion.class);
        extProfile.declare(PhotoEntry.class, GphotoVideoStatus.class);
        extProfile.declare(PhotoEntry.class, GphotoViewCount.class);
        extProfile.declare(PhotoEntry.class, GphotoWidth.class);
    }

    public GphotoAccess getAlbumAccessExt() {
        return (GphotoAccess)this.getExtension(GphotoAccess.class);
    }

    public void setAlbumAccessExt(GphotoAccess albumAccessExt) {
        if (albumAccessExt == null) {
            this.removeExtension(GphotoAccess.class);
        } else {
            this.setExtension((Extension)albumAccessExt);
        }
    }

    public boolean hasAlbumAccessExt() {
        return this.hasExtension(GphotoAccess.class);
    }

    public GphotoAlbumId getAlbumIdExt() {
        return (GphotoAlbumId)this.getExtension(GphotoAlbumId.class);
    }

    public void setAlbumIdExt(GphotoAlbumId albumIdExt) {
        if (albumIdExt == null) {
            this.removeExtension(GphotoAlbumId.class);
        } else {
            this.setExtension((Extension)albumIdExt);
        }
    }

    public boolean hasAlbumIdExt() {
        return this.hasExtension(GphotoAlbumId.class);
    }

    public GphotoChecksum getChecksumExt() {
        return (GphotoChecksum)this.getExtension(GphotoChecksum.class);
    }

    public void setChecksumExt(GphotoChecksum checksumExt) {
        if (checksumExt == null) {
            this.removeExtension(GphotoChecksum.class);
        } else {
            this.setExtension((Extension)checksumExt);
        }
    }

    public boolean hasChecksumExt() {
        return this.hasExtension(GphotoChecksum.class);
    }

    public GphotoClient getClientExt() {
        return (GphotoClient)this.getExtension(GphotoClient.class);
    }

    public void setClientExt(GphotoClient clientExt) {
        if (clientExt == null) {
            this.removeExtension(GphotoClient.class);
        } else {
            this.setExtension((Extension)clientExt);
        }
    }

    public boolean hasClientExt() {
        return this.hasExtension(GphotoClient.class);
    }

    public GphotoCommentCount getCommentCountExt() {
        return (GphotoCommentCount)this.getExtension(GphotoCommentCount.class);
    }

    public void setCommentCountExt(GphotoCommentCount commentCountExt) {
        if (commentCountExt == null) {
            this.removeExtension(GphotoCommentCount.class);
        } else {
            this.setExtension((Extension)commentCountExt);
        }
    }

    public boolean hasCommentCountExt() {
        return this.hasExtension(GphotoCommentCount.class);
    }

    public GphotoCommentsEnabled getCommentsEnabledExt() {
        return (GphotoCommentsEnabled)this.getExtension(GphotoCommentsEnabled.class);
    }

    public void setCommentsEnabledExt(GphotoCommentsEnabled commentsEnabledExt) {
        if (commentsEnabledExt == null) {
            this.removeExtension(GphotoCommentsEnabled.class);
        } else {
            this.setExtension((Extension)commentsEnabledExt);
        }
    }

    public boolean hasCommentsEnabledExt() {
        return this.hasExtension(GphotoCommentsEnabled.class);
    }

    @Override
    public ExifTags getExifTags() {
        return (ExifTags)this.getExtension(ExifTags.class);
    }

    @Override
    public void setExifTags(ExifTags exifTags) {
        if (exifTags == null) {
            this.removeExtension(ExifTags.class);
        } else {
            this.setExtension(exifTags);
        }
    }

    public boolean hasExifTags() {
        return this.hasExtension(ExifTags.class);
    }

    public GphotoFeaturedDate getFeaturedDateExt() {
        return (GphotoFeaturedDate)this.getExtension(GphotoFeaturedDate.class);
    }

    public void setFeaturedDateExt(GphotoFeaturedDate featuredDateExt) {
        if (featuredDateExt == null) {
            this.removeExtension(GphotoFeaturedDate.class);
        } else {
            this.setExtension((Extension)featuredDateExt);
        }
    }

    public boolean hasFeaturedDateExt() {
        return this.hasExtension(GphotoFeaturedDate.class);
    }

    public W3CPoint getGeoPoint() {
        return (W3CPoint)this.getExtension(W3CPoint.class);
    }

    public void setGeoPoint(W3CPoint geoPoint) {
        if (geoPoint == null) {
            this.removeExtension(W3CPoint.class);
        } else {
            this.setExtension((Extension)geoPoint);
        }
    }

    public boolean hasGeoPoint() {
        return this.hasExtension(W3CPoint.class);
    }

    public GeoRssBox getGeoRssBox() {
        return (GeoRssBox)this.getExtension(GeoRssBox.class);
    }

    public void setGeoRssBox(GeoRssBox geoRssBox) {
        if (geoRssBox == null) {
            this.removeExtension(GeoRssBox.class);
        } else {
            this.setExtension((Extension)geoRssBox);
        }
    }

    public boolean hasGeoRssBox() {
        return this.hasExtension(GeoRssBox.class);
    }

    public GeoRssPoint getGeoRssPoint() {
        return (GeoRssPoint)this.getExtension(GeoRssPoint.class);
    }

    public void setGeoRssPoint(GeoRssPoint geoRssPoint) {
        if (geoRssPoint == null) {
            this.removeExtension(GeoRssPoint.class);
        } else {
            this.setExtension((Extension)geoRssPoint);
        }
    }

    public boolean hasGeoRssPoint() {
        return this.hasExtension(GeoRssPoint.class);
    }

    public GeoRssWhere getGeoRssWhere() {
        return (GeoRssWhere)this.getExtension(GeoRssWhere.class);
    }

    public void setGeoRssWhere(GeoRssWhere geoRssWhere) {
        if (geoRssWhere == null) {
            this.removeExtension(GeoRssWhere.class);
        } else {
            this.setExtension((Extension)geoRssWhere);
        }
    }

    public boolean hasGeoRssWhere() {
        return this.hasExtension(GeoRssWhere.class);
    }

    public GmlEnvelope getGmlEnvelope() {
        return (GmlEnvelope)this.getExtension(GmlEnvelope.class);
    }

    public void setGmlEnvelope(GmlEnvelope gmlEnvelope) {
        if (gmlEnvelope == null) {
            this.removeExtension(GmlEnvelope.class);
        } else {
            this.setExtension((Extension)gmlEnvelope);
        }
    }

    public boolean hasGmlEnvelope() {
        return this.hasExtension(GmlEnvelope.class);
    }

    public GmlPoint getGmlPoint() {
        return (GmlPoint)this.getExtension(GmlPoint.class);
    }

    public void setGmlPoint(GmlPoint gmlPoint) {
        if (gmlPoint == null) {
            this.removeExtension(GmlPoint.class);
        } else {
            this.setExtension((Extension)gmlPoint);
        }
    }

    public boolean hasGmlPoint() {
        return this.hasExtension(GmlPoint.class);
    }

    public GphotoHeight getHeightExt() {
        return (GphotoHeight)this.getExtension(GphotoHeight.class);
    }

    public void setHeightExt(GphotoHeight heightExt) {
        if (heightExt == null) {
            this.removeExtension(GphotoHeight.class);
        } else {
            this.setExtension((Extension)heightExt);
        }
    }

    public boolean hasHeightExt() {
        return this.hasExtension(GphotoHeight.class);
    }

    public GphotoImageVersion getImageVersionExt() {
        return (GphotoImageVersion)this.getExtension(GphotoImageVersion.class);
    }

    public void setImageVersionExt(GphotoImageVersion imageVersionExt) {
        if (imageVersionExt == null) {
            this.removeExtension(GphotoImageVersion.class);
        } else {
            this.setExtension((Extension)imageVersionExt);
        }
    }

    public boolean hasImageVersionExt() {
        return this.hasExtension(GphotoImageVersion.class);
    }

    @Override
    public MediaGroup getMediaGroup() {
        return (MediaGroup)this.getExtension(MediaGroup.class);
    }

    public void setMediaGroup(MediaGroup mediaGroup) {
        if (mediaGroup == null) {
            this.removeExtension(MediaGroup.class);
        } else {
            this.setExtension((Extension)mediaGroup);
        }
    }

    public boolean hasMediaGroup() {
        return this.hasExtension(MediaGroup.class);
    }

    public GphotoOriginalVideo getOriginalVideo() {
        return (GphotoOriginalVideo)this.getExtension(GphotoOriginalVideo.class);
    }

    public void setOriginalVideo(GphotoOriginalVideo originalVideo) {
        if (originalVideo == null) {
            this.removeExtension(GphotoOriginalVideo.class);
        } else {
            this.setExtension((Extension)originalVideo);
        }
    }

    public boolean hasOriginalVideo() {
        return this.hasExtension(GphotoOriginalVideo.class);
    }

    public GphotoPosition getPositionExt() {
        return (GphotoPosition)this.getExtension(GphotoPosition.class);
    }

    public void setPositionExt(GphotoPosition positionExt) {
        if (positionExt == null) {
            this.removeExtension(GphotoPosition.class);
        } else {
            this.setExtension((Extension)positionExt);
        }
    }

    public boolean hasPositionExt() {
        return this.hasExtension(GphotoPosition.class);
    }

    public GphotoRotation getRotationExt() {
        return (GphotoRotation)this.getExtension(GphotoRotation.class);
    }

    public void setRotationExt(GphotoRotation rotationExt) {
        if (rotationExt == null) {
            this.removeExtension(GphotoRotation.class);
        } else {
            this.setExtension((Extension)rotationExt);
        }
    }

    public boolean hasRotationExt() {
        return this.hasExtension(GphotoRotation.class);
    }

    public GphotoSize getSizeExt() {
        return (GphotoSize)this.getExtension(GphotoSize.class);
    }

    public void setSizeExt(GphotoSize sizeExt) {
        if (sizeExt == null) {
            this.removeExtension(GphotoSize.class);
        } else {
            this.setExtension((Extension)sizeExt);
        }
    }

    public boolean hasSizeExt() {
        return this.hasExtension(GphotoSize.class);
    }

    public GphotoStarred getStarredExt() {
        return (GphotoStarred)this.getExtension(GphotoStarred.class);
    }

    public void setStarredExt(GphotoStarred starredExt) {
        if (starredExt == null) {
            this.removeExtension(GphotoStarred.class);
        } else {
            this.setExtension((Extension)starredExt);
        }
    }

    public boolean hasStarredExt() {
        return this.hasExtension(GphotoStarred.class);
    }

    public List<GphotoStreamId> getStreamIdsExt() {
        return this.getRepeatingExtension(GphotoStreamId.class);
    }

    public void addStreamIdsExt(GphotoStreamId streamIdsExt) {
        this.getStreamIdsExt().add(streamIdsExt);
    }

    public boolean hasStreamIdsExt() {
        return this.hasRepeatingExtension(GphotoStreamId.class);
    }

    public GphotoTimestamp getTimestampExt() {
        return (GphotoTimestamp)this.getExtension(GphotoTimestamp.class);
    }

    public void setTimestampExt(GphotoTimestamp timestampExt) {
        if (timestampExt == null) {
            this.removeExtension(GphotoTimestamp.class);
        } else {
            this.setExtension((Extension)timestampExt);
        }
    }

    public boolean hasTimestampExt() {
        return this.hasExtension(GphotoTimestamp.class);
    }

    public GphotoVersion getVersionExt() {
        return (GphotoVersion)this.getExtension(GphotoVersion.class);
    }

    public void setVersionExt(GphotoVersion versionExt) {
        if (versionExt == null) {
            this.removeExtension(GphotoVersion.class);
        } else {
            this.setExtension((Extension)versionExt);
        }
    }

    public boolean hasVersionExt() {
        return this.hasExtension(GphotoVersion.class);
    }

    public GphotoVideoStatus getVideoStatusExt() {
        return (GphotoVideoStatus)this.getExtension(GphotoVideoStatus.class);
    }

    public void setVideoStatusExt(GphotoVideoStatus videoStatusExt) {
        if (videoStatusExt == null) {
            this.removeExtension(GphotoVideoStatus.class);
        } else {
            this.setExtension((Extension)videoStatusExt);
        }
    }

    public boolean hasVideoStatusExt() {
        return this.hasExtension(GphotoVideoStatus.class);
    }

    public GphotoViewCount getViewCountExt() {
        return (GphotoViewCount)this.getExtension(GphotoViewCount.class);
    }

    public void setViewCountExt(GphotoViewCount viewCountExt) {
        if (viewCountExt == null) {
            this.removeExtension(GphotoViewCount.class);
        } else {
            this.setExtension((Extension)viewCountExt);
        }
    }

    public boolean hasViewCountExt() {
        return this.hasExtension(GphotoViewCount.class);
    }

    public GphotoWidth getWidthExt() {
        return (GphotoWidth)this.getExtension(GphotoWidth.class);
    }

    public void setWidthExt(GphotoWidth widthExt) {
        if (widthExt == null) {
            this.removeExtension(GphotoWidth.class);
        } else {
            this.setExtension((Extension)widthExt);
        }
    }

    public boolean hasWidthExt() {
        return this.hasExtension(GphotoWidth.class);
    }

    protected void validate() {
    }

    public String toString() {
        return "{PhotoEntry " + super.toString() + "}";
    }

    public PhotoFeed getFeed(String ... kinds) throws IOException, ServiceException {
        return this.getFeed(PhotoFeed.class, kinds);
    }

    @Override
    public String getAlbumId() {
        GphotoAlbumId ext = this.getAlbumIdExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public String getAlbumAccess() {
        GphotoAccess ext = this.getAlbumAccessExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public String getVideoStatus() {
        GphotoVideoStatus ext = this.getVideoStatusExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public String getChecksum() {
        GphotoChecksum ext = this.getChecksumExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public String getClient() {
        GphotoClient ext = this.getClientExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Integer getCommentCount() throws ServiceException {
        GphotoCommentCount ext = this.getCommentCountExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Boolean getCommentsEnabled() throws ServiceException {
        GphotoCommentsEnabled ext = this.getCommentsEnabledExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Date getFeaturedDate() {
        GphotoFeaturedDate ext = (GphotoFeaturedDate)this.getExtension(GphotoFeaturedDate.class);
        return ext == null ? null : new Date(ext.getValue());
    }

    @Override
    public Long getHeight() throws ServiceException {
        GphotoHeight ext = this.getHeightExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Float getPosition() throws ServiceException {
        GphotoPosition ext = this.getPositionExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Integer getRotation() throws ServiceException {
        GphotoRotation ext = this.getRotationExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Long getSize() throws ServiceException {
        GphotoSize ext = this.getSizeExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Date getTimestamp() throws ServiceException {
        GphotoTimestamp ext = this.getTimestampExt();
        return ext == null ? null : new Date(ext.getValue());
    }

    @Override
    public Long getVersion() throws ServiceException {
        GphotoVersion ext = this.getVersionExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Long getViewCount() {
        GphotoViewCount ext = (GphotoViewCount)this.getExtension(GphotoViewCount.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public Long getWidth() throws ServiceException {
        GphotoWidth ext = this.getWidthExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setAlbumId(Long albumId) {
        GphotoAlbumId ext = null;
        if (albumId != null) {
            ext = GphotoAlbumId.from(albumId);
        }
        this.setAlbumIdExt(ext);
    }

    @Override
    public void setAlbumId(String albumId) {
        GphotoAlbumId ext = null;
        if (albumId != null) {
            ext = new GphotoAlbumId(albumId);
        }
        this.setAlbumIdExt(ext);
    }

    @Override
    public void setAlbumAccess(String access) {
        GphotoAccess ext = null;
        if (access != null) {
            ext = new GphotoAccess(access);
        }
        this.setAlbumAccessExt(ext);
    }

    @Override
    public void setVideoStatus(String videoStatus) {
        GphotoVideoStatus ext = null;
        if (videoStatus != null) {
            ext = new GphotoVideoStatus(videoStatus);
        }
        this.setVideoStatusExt(ext);
    }

    @Override
    public void setChecksum(String checksum) {
        GphotoChecksum ext = null;
        if (checksum != null) {
            ext = new GphotoChecksum(checksum);
        }
        this.setChecksumExt(ext);
    }

    @Override
    public void setClient(String client) {
        GphotoClient ext = null;
        if (client != null) {
            ext = new GphotoClient(client);
        }
        this.setClientExt(ext);
    }

    @Override
    public void setCommentCount(Integer commentCount) {
        GphotoCommentCount ext = null;
        if (commentCount != null) {
            ext = new GphotoCommentCount(commentCount);
        }
        this.setCommentCountExt(ext);
    }

    @Override
    public void setCommentsEnabled(Boolean commentsEnabled) {
        GphotoCommentsEnabled ext = null;
        if (commentsEnabled != null) {
            ext = new GphotoCommentsEnabled(commentsEnabled);
        }
        this.setCommentsEnabledExt(ext);
    }

    @Override
    public void setFeaturedDate(Date featuredDate) {
        GphotoFeaturedDate ext = null;
        if (featuredDate != null) {
            ext = new GphotoFeaturedDate(featuredDate);
        }
        this.setFeaturedDateExt(ext);
    }

    @Override
    public void setHeight(Long height) {
        GphotoHeight ext = null;
        if (height != null) {
            ext = new GphotoHeight(height);
        }
        this.setHeightExt(ext);
    }

    @Override
    public void setPosition(Float position) {
        GphotoPosition ext = null;
        if (position != null) {
            ext = new GphotoPosition(position);
        }
        this.setPositionExt(ext);
    }

    @Override
    public void setRotation(Integer rotation) {
        GphotoRotation ext = null;
        if (rotation != null) {
            ext = new GphotoRotation(rotation);
        }
        this.setRotationExt(ext);
    }

    @Override
    public void setSize(Long size) {
        GphotoSize ext = null;
        if (size != null) {
            ext = new GphotoSize(size);
        }
        this.setSizeExt(ext);
    }

    @Override
    public void setTimestamp(Date timestamp) {
        GphotoTimestamp ext = null;
        if (timestamp != null) {
            ext = new GphotoTimestamp(timestamp);
        }
        this.setTimestampExt(ext);
    }

    @Override
    public void setVersion(Long version) {
        GphotoVersion ext = null;
        if (version != null) {
            ext = new GphotoVersion(version);
        }
        this.setVersionExt(ext);
    }

    @Override
    public void setViewCount(Long viewCount) {
        GphotoViewCount ext = null;
        if (viewCount != null) {
            ext = new GphotoViewCount(viewCount);
        }
        this.setViewCountExt(ext);
    }

    @Override
    public void setWidth(Long width) {
        GphotoWidth ext = null;
        if (width != null) {
            ext = new GphotoWidth(width);
        }
        this.setWidthExt(ext);
    }

    public Point getGeoLocation() {
        return PointDataImpl.getPoint((ExtensionPoint)this);
    }

    public void setGeoLocation(Double lat, Double lon) {
        this.setGeoLocation((Point)new GeoRssWhere(lat, lon));
    }

    public void setGeoLocation(Point point) {
        PointDataImpl.setPoint((ExtensionPoint)this, (Point)point);
    }

    public void setGeoBoundingBox(Point lowerLeft, Point upperRight) {
        this.setGeoBoundingBox((Box)new GeoRssWhere(lowerLeft, upperRight));
    }

    public void setGeoBoundingBox(Box boundingBox) {
        BoxDataImpl.setBox((ExtensionPoint)this, (Box)boundingBox);
    }

    public Box getGeoBoundingBox() {
        return BoxDataImpl.getBox((ExtensionPoint)this);
    }

    public void clearPoint() {
        PointDataImpl.clearPoint((ExtensionPoint)this);
    }

    public void clearGeoBoundingBox() {
        BoxDataImpl.clearBox((ExtensionPoint)this);
    }

    @Override
    public void addStreamId(String streamId) {
        GphotoStreamId ext = new GphotoStreamId(streamId);
        this.addStreamIdsExt(ext);
    }

    @Override
    public List<String> getStreamIds() {
        List<GphotoStreamId> exts = this.getStreamIdsExt();
        ArrayList<String> result = new ArrayList<String>();
        for (GphotoStreamId ext : exts) {
            result.add(ext.getValue());
        }
        return result;
    }

    @Override
    public List<MediaCategory> getMediaCategories() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getCategories();
    }

    @Override
    public List<MediaContent> getMediaContents() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getContents();
    }

    @Override
    public List<MediaCredit> getMediaCredits() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getCredits();
    }

    @Override
    public MediaKeywords getMediaKeywords() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return null;
        }
        return group.getKeywords();
    }

    @Override
    public List<MediaThumbnail> getMediaThumbnails() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getThumbnails();
    }

    @Override
    public void setKeywords(MediaKeywords keywords) {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            group = new MediaGroup();
            this.setMediaGroup(group);
        }
        group.setKeywords(keywords);
    }

    @Override
    public Boolean isStarred() {
        GphotoStarred ext = this.getStarredExt();
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setStarred(Boolean starred) {
        GphotoStarred ext = this.getStarredExt();
        if (ext == null) {
            ext = new GphotoStarred();
            this.setStarredExt(ext);
        }
        ext.setValue(starred);
    }

    @Override
    public Integer getTotalStars() {
        GphotoStarred ext = this.getStarredExt();
        return ext == null ? null : ext.getTotal();
    }

    @Override
    public void setTotalStars(Integer totalStars) {
        GphotoStarred ext = this.getStarredExt();
        if (ext == null) {
            ext = new GphotoStarred();
            this.setStarredExt(ext);
        }
        ext.setTotal(totalStars);
    }
}

