/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.data.Kind;
import com.google.gdata.data.ParseSource;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.InvalidEntryException;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ParseUtil;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.xml.XmlWriter;
import com.google.gdata.util.io.base.UnicodeReader;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;

public class GDataContentHandler
implements DataContentHandler {
    private static final ThreadLocal<DataContext> threadDataContext = new ThreadLocal();
    static final String XML_PREAMBLE = "((<\\?[^?]*\\?>)|(\\s))*";
    private static final Pattern FEED_DOCUMENT_PATTERN = Pattern.compile("((<\\?[^?]*\\?>)|(\\s))*<(\\w*:)?feed[\\s>].*", 32);
    private static final Pattern ENTRY_DOCUMENT_PATTERN = Pattern.compile("((<\\?[^?]*\\?>)|(\\s))*<(\\w*:)?entry[\\s>].*", 32);

    public static void setThreadDataContext(DataContext dataContext) {
        threadDataContext.set(dataContext);
    }

    public static DataContext getThreadDataContext() {
        return threadDataContext.get();
    }

    public DataFlavor[] getTransferDataFlavors() {
        throw new UnsupportedOperationException("No DataFlavor support");
    }

    public Object getTransferData(DataFlavor df, DataSource ds) {
        throw new UnsupportedOperationException("No DataFlavor support");
    }

    public Object getContent(DataSource ds) throws IOException {
        Object retObject;
        boolean isFeed;
        ContentType contentType = new ContentType(ds.getContentType());
        if (!contentType.getMediaType().equals("application/atom+xml")) {
            throw new UnsupportedOperationException("Unable to parse media: " + ds.getContentType());
        }
        String charset = contentType.getCharset();
        byte[] buf = new byte[1024];
        PushbackInputStream pushbackStream = new PushbackInputStream(ds.getInputStream(), buf.length);
        int n = pushbackStream.read(buf, 0, buf.length);
        if (n == -1) {
            throw new IOException("No content available from data source");
        }
        String parseString = charset == null ? new String(buf, 0, n) : new String(buf, 0, n, charset);
        if (FEED_DOCUMENT_PATTERN.matcher(parseString).matches()) {
            isFeed = true;
        } else if (ENTRY_DOCUMENT_PATTERN.matcher(parseString).matches()) {
            isFeed = false;
        } else {
            InvalidEntryException e = new InvalidEntryException("Unable to find Atom feed or entry element");
            throw new IOException(e.getMessage());
        }
        pushbackStream.unread(buf, 0, n);
        ParseSource source = null;
        if (charset != null) {
            source = charset.toLowerCase().startsWith("utf-") ? new ParseSource((Reader)new UnicodeReader((InputStream)pushbackStream, charset)) : new ParseSource((Reader)new InputStreamReader((InputStream)pushbackStream, charset));
        }
        DataContext dataContext = GDataContentHandler.getThreadDataContext();
        try {
            retObject = isFeed ? (dataContext != null ? ParseUtil.readFeed(source, (Class)dataContext.feedClass, (ExtensionProfile)dataContext.extProfile) : BaseFeed.readFeed(source)) : (dataContext != null ? ParseUtil.readEntry(source, (Class)dataContext.entryClass, (ExtensionProfile)dataContext.extProfile) : BaseEntry.readEntry(source));
        }
        catch (ParseException pe) {
            IOException ioe = new IOException("Unable to parse DataSource");
            ioe.initCause(pe);
            throw ioe;
        }
        catch (ServiceException se) {
            IOException ioe = new IOException("Error reading content");
            ioe.initCause(se);
            throw ioe;
        }
        return retObject;
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (obj == null) {
            throw new NullPointerException("Invalid source object");
        }
        ContentType contentType = new ContentType(mimeType);
        String charset = contentType.getCharset();
        OutputStreamWriter osw = contentType.getCharset() != null ? new OutputStreamWriter(os, contentType.getCharset()) : new OutputStreamWriter(os);
        XmlWriter xw = new XmlWriter((Writer)osw);
        ExtensionProfile extProfile = new ExtensionProfile();
        if (obj instanceof Kind.Adaptor) {
            extProfile.addDeclarations((Kind.Adaptor)obj);
        }
        boolean generateRss = mimeType.equals("application/rss+xml");
        if (obj instanceof BaseFeed) {
            BaseFeed feed = (BaseFeed)obj;
            if (generateRss) {
                feed.generateRss(xw, extProfile);
            } else {
                xw.setDefaultNamespace(Namespaces.atomNs);
                ((BaseFeed)obj).generateAtom(xw, extProfile);
            }
        } else if (obj instanceof BaseEntry) {
            BaseEntry entry = (BaseEntry)obj;
            if (generateRss) {
                ((BaseEntry)obj).generateRss(xw, extProfile);
            } else {
                xw.setDefaultNamespace(Namespaces.atomNs);
                ((BaseEntry)obj).generateAtom(xw, extProfile);
            }
        } else {
            throw new IllegalArgumentException("Cannot convert " + obj.getClass() + " object to " + mimeType);
        }
        osw.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataContext {
        private ExtensionProfile extProfile;
        private Class<? extends IEntry> entryClass;
        private Class<? extends IFeed> feedClass;

        public DataContext(ExtensionProfile extProfile, Class<? extends IEntry> entryClass, Class<? extends IFeed> feedClass) {
            this.extProfile = extProfile;
            this.entryClass = entryClass;
            this.feedClass = feedClass;
        }

        public ExtensionProfile getExtensionProfile() {
            return this.extProfile;
        }

        public Class<? extends IEntry> getEntryClass() {
            return this.entryClass;
        }

        public Class<? extends IFeed> getFeedClass() {
            return this.feedClass;
        }
    }
}

