/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.httputil;

import com.google.gdata.util.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FastURLEncoder {
    private static boolean verifyAgainstJava;
    private static final char[] HEX_DIGITS;
    private static final BitSet DEFAULT_SAFE_OCTETS;
    @Deprecated
    public static final BitSet CPLUSPLUS_COMPAT_SAFE_OCTETS;

    private FastURLEncoder() {
    }

    @VisibleForTesting
    static void setVerifyAgainstJava(boolean shouldVerify) {
        verifyAgainstJava = shouldVerify;
    }

    @VisibleForTesting
    static boolean getVerifyAgainstJava() {
        return verifyAgainstJava;
    }

    @Deprecated
    public static String encode(String s, String encoding, BitSet safeOctets, boolean plusForSpace) throws UnsupportedEncodingException {
        boolean needsEncoding;
        StringBuilder out = new StringBuilder(s.length() * 2);
        try {
            needsEncoding = FastURLEncoder.encode(s, encoding, safeOctets, plusForSpace, out);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        if (needsEncoding) {
            return out.toString();
        }
        return s;
    }

    @Deprecated
    public static boolean encode(String s, String encoding, BitSet safeOctets, boolean plusForSpace, Appendable out) throws UnsupportedEncodingException, IOException {
        byte[] data = s.getBytes(encoding);
        boolean containsSpace = false;
        int outputLength = 0;
        for (int i = 0; i < data.length; ++i) {
            int c = data[i];
            if (c < 0) {
                c += 256;
            }
            if (safeOctets.get(c)) {
                out.append((char)c);
                ++outputLength;
                continue;
            }
            if (plusForSpace && c == 32) {
                containsSpace = true;
                out.append('+');
                ++outputLength;
                continue;
            }
            out.append('%');
            out.append(HEX_DIGITS[c >> 4]);
            out.append(HEX_DIGITS[c & 0xF]);
            outputLength += 3;
        }
        return containsSpace || outputLength != s.length();
    }

    @Deprecated
    public static String encode(String s, String encoding) throws UnsupportedEncodingException {
        String jresult;
        String result = FastURLEncoder.encode(s, encoding, DEFAULT_SAFE_OCTETS, true);
        if (verifyAgainstJava && !(jresult = URLEncoder.encode(s, encoding)).equals(result)) {
            Logger.getLogger(FastURLEncoder.class.getName()).log(Level.SEVERE, "FastURLEncoder does not match java. Java: '" + jresult + "'  FastURLEncoder: '" + result + "'");
            return jresult;
        }
        return result;
    }

    @Deprecated
    public static void encode(String s, String encoding, Appendable out) throws UnsupportedEncodingException, IOException {
        FastURLEncoder.encode(s, encoding, DEFAULT_SAFE_OCTETS, true, out);
    }

    @Deprecated
    public static String encode(String s) {
        try {
            return FastURLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public static void encode(String s, Appendable out) throws IOException {
        try {
            FastURLEncoder.encode(s, "UTF-8", out);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public static String encode(String s, BitSet safeOctets, boolean plusForSpace) {
        try {
            return FastURLEncoder.encode(s, "UTF-8", safeOctets, plusForSpace);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public static BitSet createSafeOctetBitSet() {
        return (BitSet)DEFAULT_SAFE_OCTETS.clone();
    }

    static {
        int i;
        verifyAgainstJava = false;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        DEFAULT_SAFE_OCTETS = new BitSet(256);
        for (i = 48; i <= 57; ++i) {
            DEFAULT_SAFE_OCTETS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            DEFAULT_SAFE_OCTETS.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            DEFAULT_SAFE_OCTETS.set(i);
        }
        DEFAULT_SAFE_OCTETS.set(45);
        DEFAULT_SAFE_OCTETS.set(95);
        DEFAULT_SAFE_OCTETS.set(46);
        DEFAULT_SAFE_OCTETS.set(42);
        CPLUSPLUS_COMPAT_SAFE_OCTETS = new BitSet(256);
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(33);
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(41);
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(40);
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(42);
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(44);
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(45);
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(46);
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(47);
        for (i = 48; i <= 57; ++i) {
            CPLUSPLUS_COMPAT_SAFE_OCTETS.set(i);
        }
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(58);
        for (i = 65; i <= 90; ++i) {
            CPLUSPLUS_COMPAT_SAFE_OCTETS.set(i);
        }
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(95);
        for (i = 97; i <= 122; ++i) {
            CPLUSPLUS_COMPAT_SAFE_OCTETS.set(i);
        }
        CPLUSPLUS_COMPAT_SAFE_OCTETS.set(126);
    }
}

