/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.io;

import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.util.common.io.LineProcessor;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.Queue;

public final class LineReader {
    private final Readable readable;
    private final Reader reader;
    private final LineProcessor processor;
    private final Queue<String> lines = new LinkedList<String>();
    private final char[] buf = new char[4096];
    private final CharBuffer cbuf = CharBuffer.wrap(this.buf);

    public LineReader(Readable readable) {
        Preconditions.checkNotNull(readable);
        this.readable = readable;
        this.reader = readable instanceof Reader ? (Reader)readable : null;
        this.processor = new LineProcessor(){

            protected void processLine(String line, String end) {
                LineReader.this.lines.add(line);
            }
        };
    }

    public String readLine() throws IOException {
        while (this.lines.peek() == null) {
            int read;
            this.cbuf.clear();
            int n = read = this.reader != null ? this.reader.read(this.buf, 0, this.buf.length) : this.readable.read(this.cbuf);
            if (read == -1) {
                this.processor.finish();
                break;
            }
            this.processor.process(this.buf, 0, read);
        }
        return this.lines.poll();
    }
}

