/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Entry;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Feed;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.data.ParseSource;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseUtil {
    public static IEntry readEntry(ParseSource source) throws IOException, ParseException, ServiceException {
        return ParseUtil.readEntry(source, null, null);
    }

    public static <T extends IEntry> T readEntry(ParseSource source, Class<T> requestedClass, ExtensionProfile extProfile) throws IOException, ParseException, ServiceException {
        BaseEntry<?> adaptedEntry;
        BaseEntry<?> entry;
        if (source == null) {
            throw new NullPointerException("Null source");
        }
        Class<Object> entryClass = requestedClass;
        Class<Object> responseClass = requestedClass;
        if (entryClass == null) {
            entryClass = Entry.class;
            responseClass = BaseEntry.class;
        }
        boolean isAdapting = ParseUtil.isAdapting(entryClass);
        try {
            entry = (BaseEntry<?>)entryClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new ServiceException(CoreErrorDomain.ERR.cantCreateEntry, (Throwable)iae);
        }
        catch (InstantiationException ie) {
            throw new ServiceException(CoreErrorDomain.ERR.cantCreateEntry, (Throwable)ie);
        }
        BaseEntry baseEntry = entry;
        if (extProfile == null) {
            extProfile = ParseUtil.getExtProfile(baseEntry, isAdapting);
        }
        ParseUtil.parseEntry(source, baseEntry, extProfile);
        if (isAdapting && responseClass.isInstance(adaptedEntry = baseEntry.getAdaptedEntry())) {
            entry = adaptedEntry;
        }
        return (T)((IEntry)responseClass.cast(entry));
    }

    public static IFeed readFeed(ParseSource source) throws IOException, ParseException, ServiceException {
        return ParseUtil.readFeed(source, null, null);
    }

    public static <F extends IFeed> F readFeed(ParseSource source, Class<F> requestedClass, ExtensionProfile extProfile) throws IOException, ParseException, ServiceException {
        BaseFeed<?, ?> adaptedFeed;
        BaseFeed<?, ?> feed;
        if (source == null) {
            throw new NullPointerException("Null source");
        }
        Class<Object> feedClass = requestedClass;
        Class<Object> responseClass = requestedClass;
        if (feedClass == null) {
            feedClass = Feed.class;
            responseClass = BaseFeed.class;
        }
        boolean isAdapting = ParseUtil.isAdapting(feedClass);
        try {
            feed = (BaseFeed<?, ?>)feedClass.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new ServiceException(CoreErrorDomain.ERR.cantCreateFeed, (Throwable)iae);
        }
        catch (InstantiationException ie) {
            throw new ServiceException(CoreErrorDomain.ERR.cantCreateFeed, (Throwable)ie);
        }
        BaseFeed baseFeed = feed;
        if (extProfile == null) {
            extProfile = ParseUtil.getExtProfile(baseFeed, isAdapting);
        }
        ParseUtil.parseFeed(source, baseFeed, extProfile);
        if (isAdapting && responseClass.isInstance(adaptedFeed = baseFeed.getAdaptedFeed())) {
            feed = adaptedFeed;
        }
        return (F)((IFeed)responseClass.cast(feed));
    }

    private static void parseEntry(ParseSource source, BaseEntry<?> entry, ExtensionProfile extProfile) throws ParseException, IOException {
        if (source.getReader() != null) {
            entry.parseAtom(extProfile, source.getReader());
        } else if (source.getInputStream() != null) {
            entry.parseAtom(extProfile, source.getInputStream());
        } else if (source.getEventSource() != null) {
            entry.parseAtom(extProfile, source.getEventSource());
        } else {
            throw new IllegalStateException("Unexpected source: " + source);
        }
    }

    private static void parseFeed(ParseSource source, BaseFeed<?, ?> feed, ExtensionProfile extProfile) throws ParseException, IOException {
        if (source.getReader() != null) {
            feed.parseAtom(extProfile, source.getReader());
        } else if (source.getInputStream() != null) {
            feed.parseAtom(extProfile, source.getInputStream());
        } else if (source.getEventSource() != null) {
            feed.parseAtom(extProfile, source.getEventSource());
        } else {
            throw new IllegalStateException("Unexpected source: " + source);
        }
    }

    private static boolean isAdapting(Class<?> clazz) {
        return clazz == Entry.class || clazz == Feed.class;
    }

    private static ExtensionProfile getExtProfile(BaseEntry<?> entry, boolean isAdapting) {
        ExtensionProfile extProfile = null;
        extProfile = new ExtensionProfile();
        entry.declareExtensions(extProfile);
        if (isAdapting) {
            extProfile.setAutoExtending(true);
        }
        return extProfile;
    }

    private static ExtensionProfile getExtProfile(BaseFeed<?, ?> feed, boolean isAdapting) {
        ExtensionProfile extProfile = null;
        extProfile = new ExtensionProfile();
        feed.declareExtensions(extProfile);
        if (isAdapting) {
            extProfile.setAutoExtending(true);
        }
        return extProfile;
    }
}

