/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionDescription
extends ExtensionPoint
implements Comparable<ExtensionDescription> {
    private XmlNamespace namespace;
    private String localName;
    private Class<? extends Extension> extensionClass;
    private boolean required = false;
    private boolean repeatable = false;
    private boolean aggregate = false;

    public static ExtensionDescription getDefaultDescription(Class<? extends Extension> extensionClass) {
        Default defAnnot = extensionClass.getAnnotation(Default.class);
        if (defAnnot == null) {
            throw new IllegalArgumentException("No default description found for " + extensionClass);
        }
        return new ExtensionDescription(extensionClass, new XmlNamespace(defAnnot.nsAlias(), defAnnot.nsUri()), defAnnot.localName(), defAnnot.isRequired(), defAnnot.isRepeatable(), defAnnot.isAggregate());
    }

    public ExtensionDescription() {
    }

    public ExtensionDescription(Class<? extends Extension> extensionClass, XmlNamespace namespace, String localName, boolean required, boolean repeatable, boolean aggregate) {
        this.namespace = namespace;
        this.localName = localName;
        this.extensionClass = extensionClass;
        this.required = required;
        this.repeatable = repeatable;
        this.aggregate = aggregate;
    }

    public ExtensionDescription(Class<? extends Extension> extensionClass, XmlNamespace namespace, String localName) {
        this(extensionClass, namespace, localName, false, false, false);
    }

    public void setNamespace(XmlNamespace namespace) {
        this.namespace = namespace;
    }

    public final XmlNamespace getNamespace() {
        return this.namespace;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public final String getLocalName() {
        return this.localName;
    }

    public void setExtensionClass(Class<? extends Extension> extensionClass) {
        this.extensionClass = extensionClass;
    }

    public final Class<? extends Extension> getExtensionClass() {
        return this.extensionClass;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public void setRepeatable(boolean repeatable) {
        this.repeatable = repeatable;
    }

    public final boolean isRepeatable() {
        return this.repeatable;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }

    public final boolean isAggregate() {
        return this.aggregate;
    }

    @Override
    public int compareTo(ExtensionDescription desc) {
        int nscomp;
        String ns2;
        String ns1 = this.namespace.getUri();
        if (ns1 == null) {
            ns1 = "";
        }
        if ((ns2 = desc.namespace.getUri()) == null) {
            ns2 = "";
        }
        if ((nscomp = ns1.compareTo(ns2)) != 0) {
            return nscomp;
        }
        return this.localName.compareTo(desc.localName);
    }

    public void generateConfig(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        attrs.add(new XmlWriter.Attribute("namespace", this.namespace.getUri()));
        attrs.add(new XmlWriter.Attribute("localName", this.localName));
        attrs.add(new XmlWriter.Attribute("extensionClass", this.extensionClass.getName()));
        attrs.add(new XmlWriter.Attribute("required", this.required));
        attrs.add(new XmlWriter.Attribute("repeatable", this.repeatable));
        attrs.add(new XmlWriter.Attribute("aggregate", this.aggregate));
        this.generateStartElement(w, Namespaces.gdataConfigNs, "extensionDescription", attrs, null);
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.gdataConfigNs, "extensionDescription");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile configProfile, ClassLoader configLoader, List<XmlNamespace> namespaces, Attributes attrs) throws ParseException {
            super(ExtensionDescription.this, configProfile, ExtensionDescription.class);
            String nsValue = attrs.getValue("", "namespace");
            if (nsValue == null) {
                throw new ParseException(CoreErrorDomain.ERR.missingNamespace);
            }
            for (XmlNamespace declaredNs : namespaces) {
                if (!declaredNs.getAlias().equals(nsValue) && !declaredNs.getUri().equals(nsValue)) continue;
                ExtensionDescription.this.namespace = declaredNs;
                break;
            }
            if (ExtensionDescription.this.namespace == null) {
                ParseException pe = new ParseException(CoreErrorDomain.ERR.missingNamespaceDescription);
                pe.setInternalReason("No matching NamespaceDescription for " + nsValue);
                throw pe;
            }
            ExtensionDescription.this.localName = attrs.getValue("", "localName");
            if (ExtensionDescription.this.localName == null) {
                throw new ParseException(CoreErrorDomain.ERR.missingLocalName);
            }
            String extensionClassName = attrs.getValue("", "extensionClass");
            if (extensionClassName == null) {
                throw new ParseException(CoreErrorDomain.ERR.missingExtensionClass);
            }
            try {
                Class<?> extClass = configLoader.loadClass(extensionClassName);
                if (!Extension.class.isAssignableFrom(extClass)) {
                    throw new ParseException(CoreErrorDomain.ERR.mustImplementExtension);
                }
                ExtensionDescription.this.extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                ParseException pe = new ParseException(CoreErrorDomain.ERR.cantLoadExtensionClass, (Throwable)e);
                pe.setInternalReason("Unable to load extensionClass: " + extensionClassName);
                throw pe;
            }
            Boolean bool = this.getBooleanAttribute(attrs, "required");
            ExtensionDescription.this.required = bool != null && bool != false;
            bool = this.getBooleanAttribute(attrs, "repeatable");
            ExtensionDescription.this.repeatable = bool != null && bool != false;
            bool = this.getBooleanAttribute(attrs, "aggregate");
            ExtensionDescription.this.aggregate = bool != null && bool != false;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Default {
        public String nsAlias();

        public String nsUri();

        public String localName();

        public boolean isRequired() default false;

        public boolean isRepeatable() default false;

        public boolean isAggregate() default false;
    }
}

