/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.GDataProtocol;
import com.google.gdata.client.Query;
import com.google.gdata.client.batch.BatchInterruptedException;
import com.google.gdata.client.http.HttpGDataRequest;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Feed;
import com.google.gdata.data.Link;
import com.google.gdata.data.ParseSource;
import com.google.gdata.data.batch.BatchInterrupted;
import com.google.gdata.data.batch.BatchUtils;
import com.google.gdata.data.introspection.ServiceDocument;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service {
    private static final String SERVICE_VERSION = "GData-Java/" + Service.class.getPackage().getImplementationVersion() + "(gzip)";
    private static final Version CORE_VERSION = Service.initServiceVersion(Service.class, Versions.V1);
    private Version protocolVersion;
    protected ExtensionProfile extProfile = new ExtensionProfile();
    protected GDataRequestFactory requestFactory = new HttpGDataRequest.Factory();
    private ContentType contentType = ContentType.ATOM;
    protected int connectTimeout = -1;
    int readTimeout = -1;

    protected static Version initServiceVersion(Class<? extends Service> serviceClass, Version defaultVersion) {
        VersionRegistry versionRegistry = VersionRegistry.ensureRegistry();
        Version v = null;
        try {
            v = versionRegistry.getVersion(serviceClass);
        }
        catch (IllegalStateException ise) {
            try {
                v = VersionRegistry.getVersionFromProperty(serviceClass);
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (v == null) {
                v = defaultVersion;
            }
            versionRegistry.addDefaultVersion(v, false);
        }
        return v;
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(Service.class);
    }

    public Service() {
        this.requestFactory.setHeader("User-Agent", this.getServiceVersion());
        this.protocolVersion = Service.initProtocolVersion(this.getClass());
        new Feed().declareExtensions(this.extProfile);
    }

    private static Version initProtocolVersion(Class<? extends Service> serviceClass) {
        VersionRegistry registry = VersionRegistry.get();
        for (Class<? extends Service> checkClass = serviceClass; checkClass != Service.class; checkClass = checkClass.getSuperclass()) {
            try {
                return registry.getVersion(checkClass);
            }
            catch (IllegalStateException ise) {
                continue;
            }
        }
        try {
            return Service.getVersion();
        }
        catch (IllegalStateException ise) {
            return CORE_VERSION;
        }
    }

    public Version getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(Version v) {
        if (!this.protocolVersion.getServiceClass().equals(v.getServiceClass())) {
            throw new IllegalArgumentException("Invalid service class, was: " + v.getServiceClass() + ", expected: " + this.protocolVersion.getServiceClass());
        }
        this.protocolVersion = v;
    }

    protected void startVersionScope() {
        VersionRegistry.get().setThreadVersion(this.protocolVersion);
    }

    protected void endVersionScope() {
        VersionRegistry.get().resetThreadVersion();
    }

    public String getServiceVersion() {
        return SERVICE_VERSION;
    }

    public ExtensionProfile getExtensionProfile() {
        return this.extProfile;
    }

    public void setExtensionProfile(ExtensionProfile v) {
        this.extProfile = v;
    }

    public GDataRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setRequestFactory(GDataRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void useSsl() {
        if (!(this.requestFactory instanceof HttpGDataRequest.Factory)) {
            throw new UnsupportedOperationException("Not a http transport");
        }
        ((HttpGDataRequest.Factory)this.requestFactory).useSsl();
    }

    public void setAcceptLanguage(String acceptedLanguages) {
        this.requestFactory.setHeader("Accept-Language", acceptedLanguages);
    }

    public GDataRequest createRequest(GDataRequest.RequestType type, URL requestUrl, ContentType inputType) throws IOException, ServiceException {
        GDataRequest request = this.requestFactory.getRequest(type, requestUrl, inputType);
        this.setTimeouts(request);
        return request;
    }

    protected GDataRequest createRequest(Query query, ContentType inputType) throws IOException, ServiceException {
        GDataRequest request = this.requestFactory.getRequest(query, inputType);
        this.setTimeouts(request);
        return request;
    }

    public void setTimeouts(GDataRequest request) {
        if (this.connectTimeout >= 0) {
            request.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            request.setReadTimeout(this.readTimeout);
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout value cannot be negative");
        }
        this.connectTimeout = timeout;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout value cannot be negative");
        }
        this.readTimeout = timeout;
    }

    protected <E extends BaseEntry<?>> E parseEntry(Class<E> entryClass, ParseSource entrySource) throws IOException, ServiceException {
        E entry = BaseEntry.readEntry(entrySource, entryClass, this.extProfile);
        ((BaseEntry)entry).setService(this);
        return entry;
    }

    public <S extends ServiceDocument> S introspect(URL feedUrl, Class<S> serviceClass) throws IOException, ServiceException {
        String feedQuery = feedUrl.getQuery();
        if (feedQuery == null || feedQuery.indexOf("alt=atom-service") == -1) {
            char appendChar = feedQuery == null ? (char)'?' : '&';
            feedUrl = new URL(feedUrl.toString() + appendChar + "alt=atom-service");
        }
        InputStream responseStream = null;
        GDataRequest request = this.createFeedRequest(feedUrl);
        try {
            this.startVersionScope();
            request.execute();
            responseStream = request.getResponseStream();
            if (responseStream == null) {
                throw new ServiceException("Unable to obtain service document");
            }
            ServiceDocument serviceDoc = (ServiceDocument)serviceClass.newInstance();
            serviceDoc.parse(this.extProfile, responseStream);
            ServiceDocument serviceDocument = serviceDoc;
            return (S)serviceDocument;
        }
        catch (InstantiationException e) {
            throw new ServiceException("Unable to create service document instance", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Unable to create service document instance", (Throwable)e);
        }
        finally {
            this.endVersionScope();
            if (responseStream != null) {
                responseStream.close();
            }
        }
    }

    public <F extends BaseFeed<?, ?>> F getFeed(URL feedUrl, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        GDataRequest request = this.createFeedRequest(feedUrl);
        return this.getFeed(request, feedClass, ifModifiedSince);
    }

    public <F extends BaseFeed<?, ?>> F getFeed(URL feedUrl, Class<F> feedClass, String etag) throws IOException, ServiceException {
        GDataRequest request = this.createFeedRequest(feedUrl);
        return this.getFeed(request, feedClass, etag);
    }

    public <F extends BaseFeed<?, ?>> F getFeed(URL feedUrl, Class<F> feedClass) throws IOException, ServiceException {
        return this.getFeed(feedUrl, feedClass, (String)null);
    }

    public <F extends BaseFeed<?, ?>> F getFeed(Query query, Class<F> feedClass) throws IOException, ServiceException {
        return this.getFeed(query, feedClass, (String)null);
    }

    public <F extends BaseFeed<?, ?>> F getFeed(Query query, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        GDataRequest request = this.createFeedRequest(query);
        return this.getFeed(request, feedClass, ifModifiedSince);
    }

    public <F extends BaseFeed<?, ?>> F getFeed(Query query, Class<F> feedClass, String etag) throws IOException, ServiceException {
        GDataRequest request = this.createFeedRequest(query);
        return this.getFeed(request, feedClass, etag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends BaseFeed<?, ?>> F getFeed(GDataRequest request, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        F f;
        ParseSource feedSource = null;
        try {
            this.startVersionScope();
            request.setIfModifiedSince(ifModifiedSince);
            request.execute();
            feedSource = request.getParseSource();
            F feed = BaseFeed.readFeed(feedSource, feedClass, this.extProfile);
            ((BaseFeed)feed).setService(this);
            f = feed;
            this.endVersionScope();
        }
        catch (Throwable throwable) {
            this.endVersionScope();
            this.closeSource(feedSource);
            throw throwable;
        }
        this.closeSource(feedSource);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends BaseFeed<?, ?>> F getFeed(GDataRequest request, Class<F> feedClass, String etag) throws IOException, ServiceException {
        F f;
        ParseSource feedSource = null;
        try {
            this.startVersionScope();
            request.setEtag(etag);
            request.execute();
            feedSource = request.getParseSource();
            F feed = BaseFeed.readFeed(feedSource, feedClass, this.extProfile);
            ((BaseFeed)feed).setService(this);
            f = feed;
            this.endVersionScope();
        }
        catch (Throwable throwable) {
            this.endVersionScope();
            this.closeSource(feedSource);
            throw throwable;
        }
        this.closeSource(feedSource);
        return f;
    }

    public GDataRequest createFeedRequest(URL feedUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.QUERY, feedUrl, this.contentType);
    }

    public GDataRequest createFeedRequest(Query query) throws IOException, ServiceException {
        return this.createRequest(query, this.contentType);
    }

    public <E extends BaseEntry<?>> E getEntry(URL entryUrl, Class<E> entryClass) throws IOException, ServiceException {
        return this.getEntry(entryUrl, entryClass, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntry<?>> E getEntry(URL entryUrl, Class<E> entryClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        E e;
        ParseSource entrySource = null;
        GDataRequest request = this.createEntryRequest(entryUrl);
        try {
            this.startVersionScope();
            request.setIfModifiedSince(ifModifiedSince);
            request.execute();
            entrySource = request.getParseSource();
            e = this.parseEntry(entryClass, entrySource);
            this.endVersionScope();
        }
        catch (Throwable throwable) {
            this.endVersionScope();
            this.closeSource(entrySource);
            throw throwable;
        }
        this.closeSource(entrySource);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntry<?>> E getEntry(URL entryUrl, Class<E> entryClass, String etag) throws IOException, ServiceException {
        E e;
        ParseSource entrySource = null;
        GDataRequest request = this.createEntryRequest(entryUrl);
        try {
            this.startVersionScope();
            request.setEtag(etag);
            request.execute();
            entrySource = request.getParseSource();
            e = this.parseEntry(entryClass, entrySource);
            this.endVersionScope();
        }
        catch (Throwable throwable) {
            this.endVersionScope();
            this.closeSource(entrySource);
            throw throwable;
        }
        this.closeSource(entrySource);
        return e;
    }

    public GDataRequest createEntryRequest(URL entryUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.QUERY, entryUrl, this.contentType);
    }

    public <F extends BaseFeed<?, ?>> F query(Query query, Class<F> feedClass) throws IOException, ServiceException {
        return this.query(query, feedClass, (String)null);
    }

    public <F extends BaseFeed<?, ?>> F query(Query query, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        return this.getFeed(query, feedClass, ifModifiedSince);
    }

    public <F extends BaseFeed<?, ?>> F query(Query query, Class<F> feedClass, String etag) throws IOException, ServiceException {
        return this.getFeed(query, feedClass, etag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntry<?>> E insert(URL feedUrl, E entry) throws IOException, ServiceException {
        Object obj;
        if (entry == null) {
            throw new NullPointerException("Must supply entry");
        }
        ParseSource resultEntrySource = null;
        try {
            this.startVersionScope();
            GDataRequest request = this.createInsertRequest(feedUrl);
            XmlWriter xw = request.getRequestWriter();
            entry.generateAtom(xw, this.extProfile);
            xw.flush();
            request.execute();
            resultEntrySource = request.getParseSource();
            obj = this.parseEntry(entry.getClass(), resultEntrySource);
            this.endVersionScope();
        }
        catch (Throwable throwable) {
            this.endVersionScope();
            this.closeSource(resultEntrySource);
            throw throwable;
        }
        this.closeSource(resultEntrySource);
        return (E)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <F extends BaseFeed<?, ?>> F batch(URL feedUrl, F inputFeed) throws IOException, ServiceException, BatchInterruptedException {
        Object obj;
        ParseSource resultFeedSource = null;
        GDataRequest request = this.createInsertRequest(feedUrl);
        try {
            BaseEntry entry;
            BatchInterrupted interrupted;
            this.startVersionScope();
            XmlWriter xw = request.getRequestWriter();
            inputFeed.generateAtom(xw, this.extProfile);
            xw.flush();
            request.execute();
            resultFeedSource = request.getParseSource();
            Object resultFeed = BaseFeed.readFeed(resultFeedSource, inputFeed.getClass(), this.extProfile);
            ((BaseFeed)resultFeed).setService(this);
            int count = ((BaseFeed)resultFeed).getEntries().size();
            if (count > 0 && (interrupted = BatchUtils.getBatchInterrupted(entry = (BaseEntry)((BaseFeed)resultFeed).getEntries().get(count - 1))) != null) {
                throw new BatchInterruptedException((BaseFeed)resultFeed, interrupted);
            }
            obj = resultFeed;
            this.endVersionScope();
        }
        catch (Throwable throwable) {
            this.endVersionScope();
            this.closeSource(resultFeedSource);
            throw throwable;
        }
        this.closeSource(resultFeedSource);
        return (F)obj;
    }

    public GDataRequest createInsertRequest(URL feedUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.INSERT, feedUrl, this.contentType);
    }

    public GDataRequest createBatchRequest(URL feedUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.BATCH, feedUrl, this.contentType);
    }

    public <E extends BaseEntry<?>> E update(URL entryUrl, E entry) throws IOException, ServiceException {
        String etag = entry.getEtag();
        if (GDataProtocol.isWeakEtag(etag)) {
            etag = null;
        }
        return this.update(entryUrl, entry, etag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntry<?>> E update(URL entryUrl, E entry, String etag) throws IOException, ServiceException {
        Object obj;
        ParseSource resultEntrySource = null;
        GDataRequest request = this.createUpdateRequest(entryUrl);
        try {
            this.startVersionScope();
            request.setEtag(etag);
            XmlWriter xw = request.getRequestWriter();
            entry.generateAtom(xw, this.extProfile);
            xw.flush();
            request.execute();
            resultEntrySource = request.getParseSource();
            obj = this.parseEntry(entry.getClass(), resultEntrySource);
            this.endVersionScope();
        }
        catch (Throwable throwable) {
            this.endVersionScope();
            this.closeSource(resultEntrySource);
            throw throwable;
        }
        this.closeSource(resultEntrySource);
        return (E)obj;
    }

    public GDataRequest createUpdateRequest(URL entryUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.UPDATE, entryUrl, this.contentType);
    }

    public void delete(URL resourceUrl) throws IOException, ServiceException {
        this.delete(resourceUrl, null);
    }

    public void delete(URI resourceUri) throws IOException, ServiceException {
        this.delete(resourceUri.toURL(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(URL resourceUrl, String etag) throws IOException, ServiceException {
        try {
            this.startVersionScope();
            GDataRequest request = this.createDeleteRequest(resourceUrl);
            request.setEtag(etag);
            request.execute();
        }
        finally {
            this.endVersionScope();
        }
    }

    public void delete(URI resourceUri, String etag) throws IOException, ServiceException {
        this.delete(resourceUri.toURL(), etag);
    }

    public GDataRequest createDeleteRequest(URL entryUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.DELETE, entryUrl, this.contentType);
    }

    protected void closeSource(ParseSource source) throws IOException {
        if (source != null) {
            if (source.getInputStream() != null) {
                source.getInputStream().close();
            }
            if (source.getReader() != null) {
                source.getReader().close();
            }
        }
    }

    public InputStream getStreamFromLink(Link link) throws IOException, ServiceException {
        GDataRequest request = this.createRequest(GDataRequest.RequestType.QUERY, new URL(link.getHref()), null);
        request.execute();
        InputStream resultStream = request.getResponseStream();
        return resultStream;
    }

    public static interface GDataRequestFactory {
        public void setHeader(String var1, String var2);

        public void setPrivateHeader(String var1, String var2);

        public void setAuthToken(AuthTokenFactory.AuthToken var1);

        public GDataRequest getRequest(GDataRequest.RequestType var1, URL var2, ContentType var3) throws IOException, ServiceException;

        public GDataRequest getRequest(Query var1, ContentType var2) throws IOException, ServiceException;
    }

    public static interface GDataRequest {
        public void setConnectTimeout(int var1);

        public void setReadTimeout(int var1);

        public void setEtag(String var1);

        public void setIfModifiedSince(DateTime var1);

        public void setHeader(String var1, String var2);

        public void setPrivateHeader(String var1, String var2);

        public OutputStream getRequestStream() throws IOException;

        public XmlWriter getRequestWriter() throws IOException, ServiceException;

        public void execute() throws IOException, ServiceException;

        public ContentType getResponseContentType() throws IOException, ServiceException;

        public InputStream getResponseStream() throws IOException;

        public String getResponseHeader(String var1);

        public DateTime getResponseDateHeader(String var1);

        public ParseSource getParseSource() throws IOException, ServiceException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RequestType {
            QUERY,
            INSERT,
            UPDATE,
            DELETE,
            BATCH;

        }
    }

    public static class Versions {
        public static final Version V1 = new Version(Service.class, 1, 0, new Version[0]);
        public static final Version V2 = new Version(Service.class, 2, 0, new Version[0]);
        public static final Version V3 = new Version(Service.class, 3, 0, new Version[0]);
    }
}

