/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.extensions.OrgName;
import com.google.gdata.data.extensions.OrgTitle;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="organization")
public class Organization
extends ExtensionPoint {
    static final String XML_NAME = "organization";
    private static final String LABEL = "label";
    private static final String PRIMARY = "primary";
    private static final String REL = "rel";
    private String label = null;
    private Boolean primary = null;
    private String rel = null;

    public Organization() {
    }

    public Organization(String label, Boolean primary, String rel) {
        this.setLabel(label);
        this.setPrimary(primary);
        this.setRel(rel);
        this.setImmutable(true);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(Organization.class)) {
            return;
        }
        extProfile.declare(Organization.class, OrgName.class);
        extProfile.declare(Organization.class, OrgTitle.class);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.throwExceptionIfImmutable();
        this.label = label;
    }

    public boolean hasLabel() {
        return this.getLabel() != null;
    }

    public OrgName getOrgName() {
        return (OrgName)this.getExtension(OrgName.class);
    }

    public void setOrgName(OrgName orgName) {
        if (orgName == null) {
            this.removeExtension(OrgName.class);
        } else {
            this.setExtension((Extension)orgName);
        }
    }

    public boolean hasOrgName() {
        return this.hasExtension(OrgName.class);
    }

    public OrgTitle getOrgTitle() {
        return (OrgTitle)this.getExtension(OrgTitle.class);
    }

    public void setOrgTitle(OrgTitle orgTitle) {
        if (orgTitle == null) {
            this.removeExtension(OrgTitle.class);
        } else {
            this.setExtension((Extension)orgTitle);
        }
    }

    public boolean hasOrgTitle() {
        return this.hasExtension(OrgTitle.class);
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.throwExceptionIfImmutable();
        this.primary = primary;
    }

    public boolean hasPrimary() {
        return this.getPrimary() != null;
    }

    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.throwExceptionIfImmutable();
        this.rel = rel;
    }

    public boolean hasRel() {
        return this.getRel() != null;
    }

    protected void validate() {
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Organization.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put((Object)LABEL, (Object)this.label);
        generator.put(PRIMARY, (Object)this.primary);
        generator.put((Object)REL, (Object)this.rel);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.label = helper.consume(LABEL, false);
        this.primary = helper.consumeBoolean(PRIMARY, false);
        this.rel = helper.consume(REL, false);
    }

    public String toString() {
        return "{Organization label=" + this.label + " primary=" + this.primary + " rel=" + this.rel + "}";
    }

    public static final class Rel {
        public static final String OTHER = "http://schemas.google.com/g/2005#other";
        public static final String WORK = "http://schemas.google.com/g/2005#work";
    }
}

