/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamingThreadFactory
implements ThreadFactory {
    private final ThreadFactory backingFactory;
    private final String format;
    private final AtomicInteger count = new AtomicInteger(0);
    public static final ThreadFactory DEFAULT_FACTORY = Executors.defaultThreadFactory();

    public NamingThreadFactory(String format) {
        this(format, DEFAULT_FACTORY);
    }

    public NamingThreadFactory(String format, ThreadFactory backingFactory) {
        this.format = format;
        this.backingFactory = backingFactory;
        this.makeName(0);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.backingFactory.newThread(r);
        t.setName(this.makeName(this.count.getAndIncrement()));
        return t;
    }

    private String makeName(int ordinal) {
        return String.format(this.format, ordinal);
    }
}

