/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Service;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractService;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public abstract class AbstractExecutionThreadService
implements Service {
    private final Service delegate = new AbstractService(){

        @Override
        protected final void doStart() {
            AbstractExecutionThreadService.this.executor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractExecutionThreadService.this.startUp();
                        this.notifyStarted();
                        if (this.isRunning()) {
                            try {
                                AbstractExecutionThreadService.this.run();
                            }
                            catch (Throwable t) {
                                try {
                                    AbstractExecutionThreadService.this.shutDown();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw t;
                            }
                        }
                        AbstractExecutionThreadService.this.shutDown();
                        this.notifyStopped();
                    }
                    catch (Throwable t) {
                        this.notifyFailed(t);
                        throw Throwables.propagate(t);
                    }
                }
            });
        }

        @Override
        protected void doStop() {
            AbstractExecutionThreadService.this.triggerShutdown();
        }
    };

    protected void startUp() throws Exception {
    }

    protected abstract void run() throws Exception;

    protected void shutDown() throws Exception {
    }

    protected void triggerShutdown() {
    }

    protected Executor executor() {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                new Thread(command, AbstractExecutionThreadService.this.toString()).start();
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final Future<Service.State> start() {
        return this.delegate.start();
    }

    @Override
    public final Service.State startAndWait() {
        return this.delegate.startAndWait();
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    @Override
    public final Future<Service.State> stop() {
        return this.delegate.stop();
    }

    @Override
    public final Service.State stopAndWait() {
        return this.delegate.stopAndWait();
    }
}

