/*
 * Decompiled with CFR 0.152.
 */
package com.brooksandrus.util.swf;

import com.brooksandrus.util.swf.PackedBitObj;
import com.brooksandrus.util.swf.SWFCompression;
import com.brooksandrus.util.swf.SWFCompressor;
import com.brooksandrus.util.swf.SWFDecompressor;
import com.brooksandrus.util.swf.SWFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class SWFHeader
extends SWFCompression {
    private String signature;
    private String compressionType;
    private int version;
    private long size;
    private int nbits;
    private int xmax;
    private int ymax;
    private int width;
    private int height;
    private int frameRate;
    private int frameCount;
    public static String COMPRESSED = "compressed";
    public static String UNCOMPRESSED = "uncompressed";

    public SWFHeader() {
    }

    public SWFHeader(File file) throws SWFException {
        this.parseHeader(file);
    }

    public SWFHeader(String fileName) throws SWFException {
        this.parseHeader(new File(fileName));
    }

    public SWFHeader(byte[] data) throws SWFException {
        this.parseHeader(data);
    }

    public void parseHeader(File file) throws SWFException {
        FileInputStream fis = null;
        byte[] temp = new byte[this.readFullSize(file)];
        try {
            fis = new FileInputStream(file);
            fis.read(temp);
            fis.close();
        }
        catch (IOException e) {
            throw new SWFException(e);
        }
        this.parseHeader(temp);
    }

    public void parseHeader(byte[] temp) throws SWFException {
        byte[] swf;
        if (!this.isSWF(temp)) {
            throw new SWFException("File does not appear to be a swf - incorrect file signature");
        }
        this.signature = "" + (char)temp[0] + (char)temp[1] + (char)temp[2];
        if (this.isCompressed(temp[0])) {
            swf = this.uncompress(temp);
            this.compressionType = COMPRESSED;
        } else {
            swf = temp;
            this.compressionType = UNCOMPRESSED;
        }
        this.version = swf[3];
        this.size = this.readSize(swf);
        this.nbits = (swf[8] & 0xFF) >> 3;
        PackedBitObj pbo = this.readPackedBits(swf, 8, 5, this.nbits);
        PackedBitObj pbo2 = this.readPackedBits(swf, pbo.nextByteIndex, pbo.nextBitIndex, this.nbits);
        PackedBitObj pbo3 = this.readPackedBits(swf, pbo2.nextByteIndex, pbo2.nextBitIndex, this.nbits);
        PackedBitObj pbo4 = this.readPackedBits(swf, pbo3.nextByteIndex, pbo3.nextBitIndex, this.nbits);
        this.xmax = pbo2.value;
        this.ymax = pbo4.value;
        this.width = this.convertTwipsToPixels(this.xmax);
        this.height = this.convertTwipsToPixels(this.ymax);
        int bytePointer = pbo4.nextByteIndex + 2;
        this.frameRate = swf[bytePointer];
        int fc1 = swf[++bytePointer] & 0xFF;
        int fc2 = swf[++bytePointer] & 0xFF;
        ++bytePointer;
        this.frameCount = (fc2 << 8) + fc1;
    }

    public void read(byte[] output, byte[] input, int offset) {
        System.arraycopy(input, offset, output, 0, output.length - offset);
    }

    public PackedBitObj readPackedBits(byte[] bytes, int byteMarker, int bitMarker, int length) {
        int total = 0;
        int shift = 7 - bitMarker;
        int counter = 0;
        int bitIndex = bitMarker;
        int byteIndex = byteMarker;
        while (counter < length) {
            int i = bitMarker;
            while (i < 8) {
                int bit = (bytes[byteMarker] & 0xFF) >> shift & 1;
                total = (total << 1) + bit;
                bitIndex = i++;
                --shift;
                if (++counter == length) break;
            }
            byteIndex = byteMarker++;
            bitMarker = 0;
            shift = 7;
        }
        return new PackedBitObj(bitIndex, byteIndex, total);
    }

    public int convertTwipsToPixels(int twips) {
        return twips / 20;
    }

    public int convertPixelsToTwips(int pixels) {
        return pixels * 20;
    }

    public boolean isSWF(byte[] signature) {
        String sig = "" + (char)signature[0] + (char)signature[1] + (char)signature[2];
        return sig.equals("FWS") || sig.equals("CWS");
    }

    public boolean isCompressed(int firstByte) {
        return firstByte == 67;
    }

    public boolean isCompressed() {
        boolean result = false;
        if (this.signature.equalsIgnoreCase("CWS")) {
            result = true;
        }
        return result;
    }

    public byte[] compress(byte[] bytes) throws SWFException {
        return new SWFCompressor().compress(bytes);
    }

    public byte[] uncompress(byte[] bytes) throws SWFException {
        return new SWFDecompressor().uncompress(bytes);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: swf_file");
        } else {
            try {
                new SWFHeader(args[0]);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public int getNbits() {
        return this.nbits;
    }

    public String getSignature() {
        return this.signature;
    }

    public long getSize() {
        return this.size;
    }

    public int getVersion() {
        return this.version;
    }

    public int getXmax() {
        return this.xmax;
    }

    public int getYmax() {
        return this.ymax;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

