/*
 * Decompiled with CFR 0.152.
 */
package com.brooksandrus.util.swf;

import com.brooksandrus.util.swf.SWFCompression;
import com.brooksandrus.util.swf.SWFException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;

public class SWFCompressor
extends SWFCompression {
    public SWFCompressor() {
    }

    public SWFCompressor(String name) throws SWFException {
        File file = new File(name);
        this.readFile(file);
    }

    public SWFCompressor(File file) throws SWFException {
        this.readFile(file);
    }

    private void readFile(File file) throws SWFException {
        FileInputStream fis = null;
        FileOutputStream fout = null;
        byte[] swf = new byte[this.readFullSize(file)];
        try {
            fis = new FileInputStream(file);
            fis.read(swf);
            fis.close();
            byte[] temp = this.compress(swf);
            fout = new FileOutputStream(file.getAbsoluteFile());
            fout.write(temp);
            fout.flush();
            fout.close();
        }
        catch (IOException e) {
            throw new SWFException(e);
        }
    }

    public byte[] compress(byte[] bytes) throws SWFException {
        Deflater compressor = new Deflater(9);
        compressor.setInput(this.strip(bytes));
        compressor.finish();
        ByteArrayOutputStream stream = new ByteArrayOutputStream(bytes.length - 8);
        byte[] buffer = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buffer);
            stream.write(buffer, 0, count);
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new SWFException(e);
        }
        byte[] swf = new byte[8 + stream.size()];
        System.arraycopy(bytes, 0, swf, 0, 8);
        System.arraycopy(stream.toByteArray(), 0, swf, 8, stream.size());
        swf[0] = 67;
        return swf;
    }

    public static void main(String[] args) throws SWFException {
        if (args.length != 1) {
            System.err.println("Usage: swf_file");
        } else {
            new SWFCompressor(args[0]);
        }
    }
}

