package com.brooksandrus.util.swf;


import java.io.*;
import java.util.zip.*;

/**
 * @author brooks
 *
 */
public class SWFCompressor extends SWFCompression
{

   /**
    * 
    */
   public SWFCompressor()
   {
      
   }
   
   public SWFCompressor( String name ) throws SWFException
   {
      File file = new File( name );
      readFile( file );
   }
   
   public SWFCompressor( File file ) throws SWFException
   {
      readFile( file );
   }
   
   private void readFile( File file ) throws SWFException
   {
      FileInputStream fis = null;
      FileOutputStream fout = null;
      
      byte[] swf  = new byte[ readFullSize( file ) ];
      
      try
      {
         fis = new FileInputStream( file );
         fis.read( swf );
         fis.close();

         byte[] temp = compress( swf );

         fout = new FileOutputStream( file.getAbsoluteFile() );
         fout.write( temp );
         fout.flush();
         fout.close();
      }
      catch ( IOException e )
      {
         throw new SWFException(e);
      }
   }
   
   public byte[] compress( byte[] bytes ) throws SWFException
   {
      Deflater compressor = new Deflater( Deflater.BEST_COMPRESSION );
      compressor.setInput( strip( bytes ) );
      compressor.finish();
      
      ByteArrayOutputStream stream = new ByteArrayOutputStream( bytes.length - 8 );//create an expandable byte array container
      
      byte[] buffer = new byte[1024];
      while( !compressor.finished() )
      {
         int count = compressor.deflate( buffer );
         stream.write( buffer, 0, count );
      }
      try
      {
         stream.close();
      }
      catch( IOException e )
      {
         throw new SWFException(e);
      }
      
      //create a byte array that will contain the uncompressed header and the compressed data
      byte[] swf = new byte[8 + stream.size()];
      //the first 8 bytes of the header are uncompressed
      System.arraycopy( bytes, 0, swf, 0, 8 );
      //copy the compressed data from the temporary byte array to its new byte array
      System.arraycopy( stream.toByteArray(), 0, swf, 8, stream.size() );
      //the first byte of the swf indicates whether the swf is compressed or not
      swf[0] = 67;
      
      return swf;
   }

   /**
    * @param args
 * @throws SWFException 
    */
   public static void main( String[] args ) throws SWFException
   {
      if ( args.length != 1 )
      {
         System.err.println( "Usage: swf_file" );
      }
      else
      {
         new SWFCompressor( args[0] );  
      }
   }

}
