/*
 * Decompiled with CFR 0.152.
 */
package com.brooksandrus.util.swf;

import com.brooksandrus.util.swf.SWFCompression;
import com.brooksandrus.util.swf.SWFException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class SWFDecompressor
extends SWFCompression {
    public SWFDecompressor() {
    }

    public SWFDecompressor(String name) throws SWFException {
        File file = new File(name);
        this.readFile(file);
    }

    public SWFDecompressor(File file) throws SWFException {
        this.readFile(file);
    }

    private void readFile(File file) throws SWFException {
        FileInputStream fis = null;
        FileOutputStream fout = null;
        byte[] swf = new byte[this.readFullSize(file)];
        try {
            fis = new FileInputStream(file);
            fis.read(swf);
            fis.close();
            byte[] decomp = this.uncompress(swf);
            fout = new FileOutputStream(file.getAbsoluteFile());
            fout.write(decomp);
            fout.flush();
            fout.close();
        }
        catch (IOException e) {
            throw new SWFException(e);
        }
        catch (SWFException dfe) {
            throw dfe;
        }
    }

    public byte[] uncompress(byte[] bytes) throws SWFException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(this.strip(bytes));
        ByteArrayOutputStream stream = new ByteArrayOutputStream(bytes.length - 8);
        byte[] buffer = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buffer);
                stream.write(buffer, 0, count);
            }
            catch (DataFormatException dfe) {
                dfe.printStackTrace();
            }
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new SWFException(e);
        }
        byte[] swf = new byte[8 + stream.size()];
        System.arraycopy(bytes, 0, swf, 0, 8);
        System.arraycopy(stream.toByteArray(), 0, swf, 8, stream.size());
        swf[0] = 70;
        return swf;
    }

    public static void main(String[] args) throws SWFException {
        if (args.length != 1) {
            System.err.println("Usage: swf_file");
        } else {
            new SWFDecompressor(args[0]);
        }
    }
}

