/*
 * Decompiled with CFR 0.152.
 */
package atg.taglib.json;

import atg.taglib.json.JsonEntity;
import atg.taglib.json.Messages;
import atg.taglib.json.util.JSONException;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public abstract class JsonBaseTag
extends SimpleTagSupport {
    private static final String JSON_OBJECT_STACK_KEY = "atg.taglib.json.objectStack";
    private static final String PRETTY_PRINT_KEY = "atg.taglib.json.prettyPrint";
    private static final String ESCAPE_XML_KEY = "atg.taglib.json.escapeXml";
    private static final String CURRENT_ESCAPE_XML_VALUE_KEY = "atg.taglib.json.escapeXml.currentValue";
    private static final int JSON_OBJECT_STACK_SCOPE = 2;
    protected static final int PRETTY_PRINT_INDENT = 2;
    private static final boolean ESCAPE_XML_DEFAULT = true;
    private static final boolean TRIM_DEFAULT = true;
    private static final boolean PRETTY_PRINT_DEFAULT = false;
    protected String mName;
    protected boolean mTrim = true;
    protected boolean mNewStackCreated = false;
    protected Boolean mEscapeXmlOriginalValue = null;
    protected boolean mEscapeXmlValueSet = false;

    public String getName() {
        return this.mName;
    }

    public void setName(String pName) {
        this.mName = pName;
    }

    public boolean getTrim() {
        return this.mTrim;
    }

    public void setTrim(boolean pTrim) {
        this.mTrim = pTrim;
    }

    public void setPrettyPrint(boolean pPrettyPrint) {
        this.getJspContext().setAttribute(PRETTY_PRINT_KEY, (Object)pPrettyPrint);
    }

    public int getPrettyPrintIndentFactor() {
        boolean prettyPrint = this.getBooleanDefaultValue(PRETTY_PRINT_KEY, false);
        return prettyPrint ? 2 : 0;
    }

    public boolean getEscapeXml() {
        Boolean escapeXml = (Boolean)this.getJspContext().getAttribute(CURRENT_ESCAPE_XML_VALUE_KEY, 2);
        if (escapeXml == null) {
            escapeXml = this.getEscapeXmlDefault();
        }
        return escapeXml;
    }

    public void setEscapeXml(boolean pEscapeXml) {
        this.mEscapeXmlValueSet = true;
        this.mEscapeXmlOriginalValue = (Boolean)this.getJspContext().getAttribute(CURRENT_ESCAPE_XML_VALUE_KEY, 2);
        this.getJspContext().setAttribute(CURRENT_ESCAPE_XML_VALUE_KEY, (Object)pEscapeXml, 2);
    }

    public Boolean getEscapeXmlDefault() {
        return this.getBooleanDefaultValue(ESCAPE_XML_KEY, true);
    }

    protected void resetEscapeXmlValue() {
        if (this.mEscapeXmlValueSet) {
            this.getJspContext().setAttribute(CURRENT_ESCAPE_XML_VALUE_KEY, (Object)this.mEscapeXmlOriginalValue, 2);
        }
    }

    protected Stack getEntityStack() throws JspException {
        Stack stack = (Stack)this.getJspContext().getAttribute(JSON_OBJECT_STACK_KEY, 2);
        if (stack == null) {
            stack = this.createEntityStack();
            this.mNewStackCreated = true;
        }
        return stack;
    }

    protected Stack createEntityStack() throws JspException {
        Stack stack = new Stack();
        this.getJspContext().setAttribute(JSON_OBJECT_STACK_KEY, stack, 2);
        return stack;
    }

    protected void removeEntityStack() {
        this.getJspContext().removeAttribute(JSON_OBJECT_STACK_KEY, 2);
    }

    protected JsonEntity getCurrentEntity() throws JspException {
        return (JsonEntity)this.getEntityStack().peek();
    }

    protected boolean entityStackExists() {
        return this.getJspContext().getAttribute(JSON_OBJECT_STACK_KEY, 2) != null;
    }

    protected boolean isRootTag() {
        return this.mNewStackCreated;
    }

    protected Object getDefaultValue(String pParamKey, Object pDefaultConstant) {
        Object value = this.getJspContext().findAttribute(pParamKey);
        if (value != null) {
            return value;
        }
        ServletContext servletContext = ((PageContext)this.getJspContext()).getServletContext();
        value = servletContext.getInitParameter(pParamKey);
        if (value != null) {
            return value;
        }
        return pDefaultConstant;
    }

    private boolean getBooleanDefaultValue(String pParamKey, Object pDefaultConstant) {
        Object defaultValue = this.getDefaultValue(pParamKey, pDefaultConstant);
        if (defaultValue instanceof String) {
            return Boolean.valueOf((String)defaultValue);
        }
        if (defaultValue instanceof Boolean) {
            return (Boolean)defaultValue;
        }
        return false;
    }

    protected Object trimAndEscapeValue(Object pValue) {
        if (!(pValue instanceof String)) {
            return pValue;
        }
        String result = (String)pValue;
        if (this.getTrim()) {
            result = result.trim();
        }
        if (this.getEscapeXml()) {
            result = result.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&#039;").replaceAll("\"", "&#034;");
        }
        return result;
    }

    protected void processTagEnd(JsonEntity pNewEntity) throws JspException, JSONException {
        if (this.isRootTag()) {
            try {
                JspWriter out = this.getJspContext().getOut();
                String jsonText = this.getPrettyPrintIndentFactor() > 0 ? pNewEntity.toString(this.getPrettyPrintIndentFactor()) : pNewEntity.toString();
                out.write(jsonText);
            }
            catch (Exception e) {
                throw new JspException(Messages.getString("atg.taglib.json.error.base.0"), (Throwable)e);
            }
            finally {
                this.removeEntityStack();
            }
        } else {
            this.getCurrentEntity().add(pNewEntity.getWrappedObject(), this.getName());
        }
        this.resetEscapeXmlValue();
    }
}

