package cz.geek.cloudmailin;

import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.WebRequest;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractCloudMailinController {

	private String secret;

	private boolean validate = true;

	public void setSecret(String secret) {
		this.secret = secret;
	}

	public void setValidate(boolean validate) {
		this.validate = validate;
	}

	@RequestMapping(method = RequestMethod.POST)
	public ResponseEntity<String> post(@ModelAttribute CloudMailin data, WebRequest req) {
		if (validate())
			validate(req);
		return handle(data);
	}

	@RequestMapping
	public void get(HttpServletResponse resp) throws IOException {
		resp.sendError(HttpServletResponse.SC_NOT_FOUND);
	}

	@ModelAttribute
	protected CloudMailin model() {
		return new CloudMailin();
	}
	/**
	 * This method should return eg. <code>{@literal new ResponseEntity<String>(HttpStatus.OK)}</code>
	 * @param data request data
	 * @return response
	 */
	protected abstract ResponseEntity<String> handle(CloudMailin data);

	protected boolean validate() {
		return validate && secret != null;
	}

	protected void validate(WebRequest req) {
		Assert.notNull(req, "WebRequest must not be null");
		if (secret == null)
			throw new IllegalStateException("Secret must be set");
		String signature = null;
		StringBuilder b = new StringBuilder();
		TreeMap<String, String[]> map = new TreeMap<String, String[]>(req.getParameterMap());
		for (Map.Entry<String,String[]> entry: map.entrySet()) {
			if ("signature".equals(entry.getKey())) {
				signature = entry.getValue()[0];
				continue;
			}
			for (String i: entry.getValue())
				b.append(i);
		}
		if (b.length() == 0)
			throw new IllegalStateException("No input data");
		if (signature == null)
			throw new IllegalStateException("Signature was not present in the request, have only " + map.keySet());
		b.append(secret);
		String digest = DigestUtils.md5Hex(b.toString());
		if (!signature.equals(digest))
			throw new IllegalArgumentException("Signatures does not match");
	}
}
